/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import org.apache.james.event.json.SerializerFixture;
import org.apache.james.events.Event;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import scala.math.BigDecimal;

class EventIdTest {
    EventIdTest() {
    }

    @Test
    void eventIdShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.eventIdWrites().writes((Object)SerializerFixture.EVENT_ID)).isEqualTo((Object)new JsString("6e0dd59d-660e-4d9b-b22f-0354479f47b4"));
    }

    @Test
    void eventIdShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((Event.EventId)SerializerFixture.DTO_JSON_SERIALIZE.eventIdReads().reads((JsValue)new JsString("6e0dd59d-660e-4d9b-b22f-0354479f47b4")).get())).isEqualTo((Object)SerializerFixture.EVENT_ID);
    }

    @Test
    void eventIdDeserializationShouldReturnErrorWhenNumber() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.eventIdReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L)))).isInstanceOf(JsError.class);
    }

    @Test
    void eventIdDeserializationShouldReturnErrorWhenNull() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.eventIdReads().reads((JsValue)JsNull$.MODULE$)).isInstanceOf(JsError.class);
    }

    @Test
    void eventIdDeserializationShouldThrowWhenInvalid() {
        Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.eventIdReads().reads((JsValue)new JsString("invalid"))).isInstanceOf(IllegalArgumentException.class);
    }
}

