/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.james.event.json.DTOs;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import scala.math.BigDecimal;

class ACLDiffTest {
    ACLDiffTest() {
    }

    @Test
    void deSerializeShouldThrowWhenNewACLIsMissing() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.aclDiffReads().reads(Json.parse((String)"{\"oldACL\":{}}"))).isInstanceOf(JsError.class);
    }

    @Test
    void deSerializeShouldAcceptDoubleRight() {
        Assertions.assertThat((Object)((DTOs.ACLDiff)SerializerFixture.DTO_JSON_SERIALIZE.aclDiffReads().reads(Json.parse((String)"{\"oldACL\":{\"$any\":\"aa\"},\"newACL\":{}}")).get()).toJava()).isEqualTo((Object)new ACLDiff(new MailboxACL((Map)ImmutableMap.of((Object)new MailboxACL.EntryKey("any", MailboxACL.NameType.group, false), (Object)new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Administer}))), new MailboxACL()));
    }

    @Test
    void deSerializeShouldAcceptEmptyRight() {
        Assertions.assertThat((Object)((DTOs.ACLDiff)SerializerFixture.DTO_JSON_SERIALIZE.aclDiffReads().reads(Json.parse((String)"{\"oldACL\":{\"$any\":\"\"},\"newACL\":{}}")).get()).toJava()).isEqualTo((Object)new ACLDiff(new MailboxACL((Map)ImmutableMap.of((Object)new MailboxACL.EntryKey("any", MailboxACL.NameType.group, false), (Object)new MailboxACL.Rfc4314Rights(new MailboxACL.Right[0]))), new MailboxACL()));
    }

    @Test
    void deSerializeShouldThrowWhenOldACLIsMissing() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.aclDiffReads().reads(Json.parse((String)"{\"newACL\":{}}"))).isInstanceOf(JsError.class);
    }

    @Nested
    class RightTest {
        RightTest() {
        }

        @Test
        void deSerializeShouldThrowWhenUnsupportedRightInNewACL() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.aclRightsReads().reads((JsValue)new JsString("\"unsupported\""))).isInstanceOf(UnsupportedRightException.class);
        }

        @Test
        void deSerializeShouldThrowWhenNull() {
            Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.aclRightsReads().reads((JsValue)JsNull$.MODULE$)).isInstanceOf(JsError.class);
        }

        @Test
        void deSerializeShouldThrowWhenRightIsNotString() {
            Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.aclRightsReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L)))).isInstanceOf(JsError.class);
        }
    }

    @Nested
    class EntryKeyTest {
        EntryKeyTest() {
        }

        @Test
        void deSerializeShouldThrowWhenNotIncludedNameInEntryKey() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.aclEntryKeyReads().reads((JsValue)new JsString("$"))).isInstanceOf(IllegalStateException.class);
        }

        @Test
        void deSerializeShouldThrowWhenNameInEntryKeyIsEmpty() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.aclEntryKeyReads().reads((JsValue)new JsString(""))).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        void deSerializeShouldThrowWhenNameInEntryKeyIsNotWellFormatted() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.aclEntryKeyReads().reads((JsValue)new JsString("-"))).isInstanceOf(StringIndexOutOfBoundsException.class);
        }

        @Test
        void deSerializeShouldThrowWhenNameInEntryKeyIsNull() {
            Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.aclEntryKeyReads().reads((JsValue)JsNull$.MODULE$)).isInstanceOf(JsError.class);
        }

        @Test
        void deSerializeShouldThrowWhenNameInEntryKeyIsNotString() {
            Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.aclEntryKeyReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L)))).isInstanceOf(JsError.class);
        }
    }
}

