/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json;

import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.events.Event;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.TestId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class MailboxDeletionSerializationTest {
    private static final MailboxSession.SessionId SESSION_ID = MailboxSession.SessionId.of((long)3652L);
    private static final Username USERNAME = Username.of((String)"user");
    private static final MailboxPath MAILBOX_PATH = new MailboxPath("#private", USERNAME, "mailboxName");
    private static final MailboxId MAILBOX_ID = TestId.of((long)789L);
    private static final QuotaRoot QUOTA_ROOT = QuotaRoot.quotaRoot((String)"#private&user@domain", Optional.of(Domain.of((String)"domain")));
    private static final QuotaCountUsage DELETED_MESSAGE_COUNT = QuotaCountUsage.count((long)60L);
    private static final QuotaSizeUsage TOTAL_DELETED_SIZE = QuotaSizeUsage.size((long)100L);
    private static final MailboxEvents.MailboxDeletion DEFAULT_MAILBOX_DELETION_EVENT = new MailboxEvents.MailboxDeletion(SESSION_ID, USERNAME, MAILBOX_PATH, new MailboxACL(new Map.Entry[]{Pair.of((Object)MailboxACL.EntryKey.createUserEntryKey((Username)USERNAME), (Object)new MailboxACL.Rfc4314Rights((Collection)MailboxACL.Right.allRights))}), QUOTA_ROOT, DELETED_MESSAGE_COUNT, TOTAL_DELETED_SIZE, MAILBOX_ID, SerializerFixture.EVENT_ID);
    private static final MailboxEvents.MailboxDeletion EMPTY_ACL_MAILBOX_DELETION_EVENT = new MailboxEvents.MailboxDeletion(SESSION_ID, USERNAME, MAILBOX_PATH, new MailboxACL(), QUOTA_ROOT, DELETED_MESSAGE_COUNT, TOTAL_DELETED_SIZE, MAILBOX_ID, SerializerFixture.EVENT_ID);
    private static final String DEFAULT_EVENT_JSON = "{  \"MailboxDeletion\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxACL\":{      \"entries\": {        \"user\":\"aeiklprstwx\"       }    },    \"sessionId\":3652,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"mailboxName\"    },    \"quotaRoot\":\"#private&user@domain\",    \"deletedMessageCount\":60,    \"totalDeletedSize\":100,    \"mailboxId\":\"789\"  }}";
    private static final String EVENT_WITH_EMPTY_ACL_JSON = "{  \"MailboxDeletion\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxACL\":{      \"entries\": {}    },    \"sessionId\":3652,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"mailboxName\"    },    \"quotaRoot\":\"#private&user@domain\",    \"deletedMessageCount\":60,    \"totalDeletedSize\":100,    \"mailboxId\":\"789\"  }}";
    private static final String LEGACY_EVENT_JSON = "{  \"MailboxDeletion\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":3652,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"mailboxName\"    },    \"quotaRoot\":\"#private&user@domain\",    \"deletedMessageCount\":60,    \"totalDeletedSize\":100,    \"mailboxId\":\"789\"  }}";

    MailboxDeletionSerializationTest() {
    }

    @Test
    void mailboxDeletionShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)DEFAULT_MAILBOX_DELETION_EVENT)).isEqualTo((Object)DEFAULT_EVENT_JSON);
    }

    @Test
    void mailboxDeletionShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(DEFAULT_EVENT_JSON).get())).isEqualTo((Object)DEFAULT_MAILBOX_DELETION_EVENT);
    }

    @Test
    void mailboxDeletionWithEmptyACLShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)EMPTY_ACL_MAILBOX_DELETION_EVENT)).isEqualTo((Object)EVENT_WITH_EMPTY_ACL_JSON);
    }

    @Test
    void legacyMailboxDeletionShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(LEGACY_EVENT_JSON).get())).isEqualTo((Object)EMPTY_ACL_MAILBOX_DELETION_EVENT);
    }

    @Nested
    class DeserializationErrors {
        DeserializationErrors() {
        }

        @Test
        void mailboxDeletionShouldThrowWhenMissingSessionId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxDeletion\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"mailboxName\"    },    \"quotaRoot\":\"#private&user@domain\",    \"deletedMessageCount\":60,    \"totalDeletedSize\":100,    \"mailboxId\":\"789\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxDeletionShouldThrowWhenMissingEventId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxDeletion\":{    \"sessionId\":42,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"mailboxName\"    },    \"quotaRoot\":\"#private&user@domain\",    \"deletedMessageCount\":60,    \"totalDeletedSize\":100,    \"mailboxId\":\"789\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxDeletionShouldThrowWhenMissingUser() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxDeletion\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":3652,    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"mailboxName\"    },    \"quotaRoot\":\"#private&user@domain\",    \"deletedMessageCount\":60,    \"totalDeletedSize\":100,    \"mailboxId\":\"789\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxDeletionShouldThrowWhenMissingQuotaRoot() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxDeletion\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":3652,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"mailboxName\"    },    \"deletedMessageCount\":60,    \"totalDeletedSize\":100,    \"mailboxId\":\"789\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxDeletionShouldThrowWhenMissingQuotaCount() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxDeletion\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":3652,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"mailboxName\"    },    \"quotaRoot\":\"#private&user@domain\",    \"totalDeletedSize\":100,    \"mailboxId\":\"789\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxDeletionShouldThrowWhenMissingQuotaSize() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxDeletion\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":3652,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"mailboxName\"    },    \"quotaRoot\":\"#private&user@domain\",    \"deletedMessageCount\":60,    \"mailboxId\":\"789\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxDeletionShouldThrowWhenMissingMailboxId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxDeletion\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":3652,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"mailboxName\"    },    \"quotaRoot\":\"#private&user@domain\",    \"deletedMessageCount\":60,    \"totalDeletedSize\":100  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxDeletionShouldThrowWhenMissingPath() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxDeletion\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":3652,    \"user\":\"user\",    \"quotaRoot\":\"#private&user@domain\",    \"deletedMessageCount\":60,    \"totalDeletedSize\":100,    \"mailboxId\":\"789\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }
    }
}

