/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json;

import java.util.NoSuchElementException;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.Username;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.events.Event;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.TestId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class MailboxAddedSerializationTest {
    private static final Username USERNAME = Username.of((String)"user");
    private static final MailboxEvents.MailboxAdded EVENT_1 = new MailboxEvents.MailboxAdded(MailboxSession.SessionId.of((long)42L), USERNAME, new MailboxPath("#private", Username.of((String)"bob"), "mailboxName"), (MailboxId)TestId.of((long)18L), SerializerFixture.EVENT_ID);
    private static final String JSON_1 = "{  \"MailboxAdded\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxPath\":{      \"namespace\":\"#private\",      \"user\":\"bob\",      \"name\":\"mailboxName\"     },     \"mailboxId\":\"18\",     \"user\":\"user\",     \"sessionId\":42  }}";

    MailboxAddedSerializationTest() {
    }

    @Test
    void mailboxAddedShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)EVENT_1)).isEqualTo((Object)JSON_1);
    }

    @Test
    void mailboxAddedShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(JSON_1).get())).isEqualTo((Object)EVENT_1);
    }

    @Nested
    class DeserializationErrors {
        DeserializationErrors() {
        }

        @Test
        void fromJsonShouldRejectMissingSessionId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxAdded\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxPath\":{      \"namespace\":\"#private\",      \"user\":\"bob\"     },     \"mailboxId\":\"18\",     \"user\":\"user\",     \"sessionId\":18  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void fromJsonShouldRejectMissingEventId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxAdded\":{    \"sessionId\":42,    \"mailboxPath\":{      \"namespace\":\"#private\",      \"user\":\"bob\"     },     \"mailboxId\":\"18\",     \"user\":\"user\",     \"sessionId\":18  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void fromJsonShouldRejectMissingMailboxId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxAdded\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxPath\":{      \"namespace\":\"#private\",      \"user\":\"bob\",      \"name\":\"mailboxName\"     },     \"user\":\"user\",     \"sessionId\":18  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void fromJsonShouldRejectMissingUser() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxAdded\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxPath\":{      \"namespace\":\"#private\",      \"user\":\"bob\",      \"name\":\"mailboxName\"     },     \"mailboxId\":\"18\",     \"sessionId\":18  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void fromJsonShouldRejectMissingMailboxPath() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxAdded\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",     \"mailboxId\":\"18\",     \"user\":\"user\",     \"sessionId\":18  }}").get()).isInstanceOf(NoSuchElementException.class);
        }
    }
}

