/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.mail.Flags;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.core.Username;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.events.Event;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.TestMessageId;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class FlagsUpdatedSerializationTest {
    private static final Username USERNAME = Username.of((String)"user");
    private static final MailboxSession.SessionId SESSION_ID = MailboxSession.SessionId.of((long)42L);
    private static final MailboxId MAILBOX_ID = TestId.of((long)18L);
    private static final String MAILBOX_NAME = "mailboxName";
    private static final MailboxPath MAILBOX_PATH = new MailboxPath("#private", Username.of((String)"user"), "mailboxName");
    private static final MessageUid MESSAGE_UID_1 = MessageUid.of((long)123456L);
    private static final MessageUid MESSAGE_UID_2 = MessageUid.of((long)654321L);
    private static final ModSeq MOD_SEQ_1 = ModSeq.of((long)35L);
    private static final Flags OLD_FLAGS_1 = FlagsBuilder.builder().add(new Flags.Flag[]{Flags.Flag.SEEN, Flags.Flag.DELETED}).add(new String[]{"Old Flag 1"}).build();
    private static final Flags NEW_FLAGS_1 = FlagsBuilder.builder().add(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.DRAFT}).add(new String[]{"New Flag 1"}).build();
    private static UpdatedFlags UPDATED_FLAG_1 = UpdatedFlags.builder().uid(MESSAGE_UID_1).modSeq(MOD_SEQ_1).oldFlags(OLD_FLAGS_1).newFlags(NEW_FLAGS_1).build();
    private static final ModSeq MOD_SEQ_2 = ModSeq.of((long)36L);
    private static final Flags OLD_FLAGS_2 = FlagsBuilder.builder().add(new Flags.Flag[]{Flags.Flag.RECENT, Flags.Flag.FLAGGED}).add(new String[]{"Old Flag 2"}).build();
    private static final Flags NEW_FLAGS_2 = FlagsBuilder.builder().add(new Flags.Flag[]{Flags.Flag.SEEN, Flags.Flag.ANSWERED}).add(new String[]{"New Flag 2"}).build();
    private static UpdatedFlags UPDATED_FLAG_2 = UpdatedFlags.builder().uid(MESSAGE_UID_2).modSeq(MOD_SEQ_2).oldFlags(OLD_FLAGS_2).newFlags(NEW_FLAGS_2).build();
    private static List<UpdatedFlags> UPDATED_FLAGS_LIST = ImmutableList.of((Object)UPDATED_FLAG_1, (Object)UPDATED_FLAG_2);
    private static final MailboxEvents.FlagsUpdated DEFAULT_EVENT = new MailboxEvents.FlagsUpdated(SESSION_ID, USERNAME, MAILBOX_PATH, MAILBOX_ID, UPDATED_FLAGS_LIST, SerializerFixture.EVENT_ID);
    private static final String DEFAULT_EVENT_JSON = "{  \"FlagsUpdated\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"sessionId\": 42,    \"updatedFlags\": [      {        \"uid\": 123456,        \"modSeq\": 35,        \"oldFlags\": {\"systemFlags\":[\"Deleted\",\"Seen\"],\"userFlags\":[\"Old Flag 1\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Draft\"],\"userFlags\":[\"New Flag 1\"]}      },      {        \"uid\": 654321,        \"modSeq\": 36,        \"oldFlags\": {\"systemFlags\":[\"Flagged\",\"Recent\"],\"userFlags\":[\"Old Flag 2\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Seen\"],\"userFlags\":[\"New Flag 2\"]}      }    ],    \"user\": \"user\"  }}";

    FlagsUpdatedSerializationTest() {
    }

    @Test
    void flagsUpdatedShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)DEFAULT_EVENT)).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)DEFAULT_EVENT_JSON);
    }

    @Test
    void flagsUpdatedShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(DEFAULT_EVENT_JSON).get())).isEqualTo((Object)DEFAULT_EVENT);
    }

    @Nested
    class DeserializationError {
        DeserializationError() {
        }

        @Test
        void flagsUpdatedShouldThrowWhenMissingSessionId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"FlagsUpdated\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"updatedFlags\": [      {        \"uid\": 123456,        \"modSeq\": 35,        \"oldFlags\": {\"systemFlags\":[\"Deleted\",\"Seen\"],\"userFlags\":[\"Old Flag 1\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Draft\"],\"userFlags\":[\"New Flag 1\"]}      },      {        \"uid\": 654321,        \"modSeq\": 36,        \"oldFlags\": {\"systemFlags\":[\"Flagged\",\"Recent\"],\"userFlags\":[\"Old Flag 2\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Seen\"],\"userFlags\":[\"New Flag 2\"]}      }    ],    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void flagsUpdatedShouldThrowWhenMissingEventId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"FlagsUpdated\": {    \"sessionId\":42,    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"updatedFlags\": [],    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void flagsUpdatedShouldThrowWhenMissingUser() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"FlagsUpdated\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"sessionId\": 42,    \"updatedFlags\": [      {        \"uid\": 123456,        \"modSeq\": 35,        \"oldFlags\": {\"systemFlags\":[\"Deleted\",\"Seen\"],\"userFlags\":[\"Old Flag 1\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Draft\"],\"userFlags\":[\"New Flag 1\"]}      },      {        \"uid\": 654321,        \"modSeq\": 36,        \"oldFlags\": {\"systemFlags\":[\"Flagged\",\"Recent\"],\"userFlags\":[\"Old Flag 2\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Seen\"],\"userFlags\":[\"New Flag 2\"]}      }    ]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void flagsUpdatedShouldThrowWhenMissingMailboxId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"FlagsUpdated\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"sessionId\": 42,    \"updatedFlags\": [      {        \"uid\": 123456,        \"modSeq\": 35,        \"oldFlags\": {\"systemFlags\":[\"Deleted\",\"Seen\"],\"userFlags\":[\"Old Flag 1\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Draft\"],\"userFlags\":[\"New Flag 1\"]}      },      {        \"uid\": 654321,        \"modSeq\": 36,        \"oldFlags\": {\"systemFlags\":[\"Flagged\",\"Recent\"],\"userFlags\":[\"Old Flag 2\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Seen\"],\"userFlags\":[\"New Flag 2\"]}      }    ],    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void flagsUpdatedShouldThrowWhenMissingMailboxPath() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"FlagsUpdated\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": 482,      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"sessionId\": 42,    \"updatedFlags\": [      {        \"uid\": 123456,        \"modSeq\": 35,        \"oldFlags\": {\"systemFlags\":[\"Deleted\",\"Seen\"],\"userFlags\":[\"Old Flag 1\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Draft\"],\"userFlags\":[\"New Flag 1\"]}      },      {        \"uid\": 654321,        \"modSeq\": 36,        \"oldFlags\": {\"systemFlags\":[\"Flagged\",\"Recent\"],\"userFlags\":[\"Old Flag 2\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Seen\"],\"userFlags\":[\"New Flag 2\"]}      }    ],    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }
    }

    @Nested
    class WithMessageId {
        private final MessageId messageId1 = TestMessageId.of((long)23456L);
        private final MessageId messageId2 = TestMessageId.of((long)78901L);
        private final UpdatedFlags updatedFlagsWithMessageId1 = UpdatedFlags.builder().uid(MESSAGE_UID_1).messageId(this.messageId1).modSeq(MOD_SEQ_1).oldFlags(OLD_FLAGS_1).newFlags(NEW_FLAGS_1).build();
        private final UpdatedFlags updatedFlagsWithMessageId2 = UpdatedFlags.builder().uid(MESSAGE_UID_2).messageId(this.messageId2).modSeq(MOD_SEQ_2).oldFlags(OLD_FLAGS_2).newFlags(NEW_FLAGS_2).build();
        private final List<UpdatedFlags> updatedFlagsListWithMessageIds = ImmutableList.of((Object)this.updatedFlagsWithMessageId1, (Object)this.updatedFlagsWithMessageId2);
        private final MailboxEvents.FlagsUpdated eventWithMessageIds = new MailboxEvents.FlagsUpdated(SESSION_ID, USERNAME, MAILBOX_PATH, MAILBOX_ID, this.updatedFlagsListWithMessageIds, SerializerFixture.EVENT_ID);
        private static final String EVENT_WITH_MESSAGE_IDS_JSON = "{  \"FlagsUpdated\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"sessionId\": 42,    \"updatedFlags\": [      {        \"uid\": 123456,        \"messageId\": \"23456\",        \"modSeq\": 35,        \"oldFlags\": {\"systemFlags\":[\"Deleted\",\"Seen\"],\"userFlags\":[\"Old Flag 1\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Draft\"],\"userFlags\":[\"New Flag 1\"]}      },      {        \"uid\": 654321,        \"messageId\": \"78901\",        \"modSeq\": 36,        \"oldFlags\": {\"systemFlags\":[\"Flagged\",\"Recent\"],\"userFlags\":[\"Old Flag 2\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Seen\"],\"userFlags\":[\"New Flag 2\"]}      }    ],    \"user\": \"user\"  }}";

        WithMessageId() {
        }

        @Test
        void flagsUpdatedShouldBeWellSerialized() {
            JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)this.eventWithMessageIds)).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)EVENT_WITH_MESSAGE_IDS_JSON);
        }

        @Test
        void flagsUpdatedShouldBeWellDeSerialized() {
            Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(EVENT_WITH_MESSAGE_IDS_JSON).get())).isEqualTo((Object)this.eventWithMessageIds);
        }
    }

    @Nested
    class WithEmptyUpdatedFlags {
        private final List<UpdatedFlags> emptyUpdatedFlags = ImmutableList.of();
        private final MailboxEvents.FlagsUpdated emptyUpdatedFlagsEvent = new MailboxEvents.FlagsUpdated(SESSION_ID, USERNAME, MAILBOX_PATH, MAILBOX_ID, this.emptyUpdatedFlags, SerializerFixture.EVENT_ID);
        private static final String EVENT_JSON_WITH_EMPTY_UPDATED_FLAGS = "{  \"FlagsUpdated\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"sessionId\": 42,    \"updatedFlags\": [],    \"user\": \"user\"  }}";

        WithEmptyUpdatedFlags() {
        }

        @Test
        void flagsUpdatedShouldBeWellSerialized() {
            JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)this.emptyUpdatedFlagsEvent)).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)EVENT_JSON_WITH_EMPTY_UPDATED_FLAGS);
        }

        @Test
        void flagsUpdatedShouldBeWellDeSerialized() {
            Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(EVENT_JSON_WITH_EMPTY_UPDATED_FLAGS).get())).isEqualTo((Object)this.emptyUpdatedFlagsEvent);
        }
    }
}

