/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json;

import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.mail.Flags;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.Username;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.events.Event;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.TestMessageId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class ExpungedSerializationTest {
    private static final Username USERNAME = Username.of((String)"user");
    private static final MailboxSession.SessionId SESSION_ID = MailboxSession.SessionId.of((long)42L);
    private static final MailboxId MAILBOX_ID = TestId.of((long)18L);
    private static final String MAILBOX_NAME = "mailboxName";
    private static final MailboxPath MAILBOX_PATH = new MailboxPath("#private", Username.of((String)"user"), "mailboxName");
    private static final MessageUid MESSAGE_UID = MessageUid.of((long)123456L);
    private static final Instant INSTANT = Instant.parse("2018-12-14T09:41:51.541Z");
    private static final TestMessageId MESSAGE_ID = TestMessageId.of((long)42L);
    private static final ModSeq MOD_SEQ = ModSeq.of((long)35L);
    private static final int SIZE = 45;
    private static final Flags FLAGS = FlagsBuilder.builder().add(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.DRAFT}).add(new String[]{"User Custom Flag"}).build();
    private static final Map<MessageUid, MessageMetaData> EXPUNGED = ImmutableMap.of((Object)MESSAGE_UID, (Object)new MessageMetaData(MESSAGE_UID, MOD_SEQ, FLAGS, 45L, Date.from(INSTANT), (MessageId)MESSAGE_ID));
    private static final MailboxEvents.Expunged DEFAULT_EXPUNGED_EVENT = new MailboxEvents.Expunged(SESSION_ID, USERNAME, MAILBOX_PATH, MAILBOX_ID, EXPUNGED, SerializerFixture.EVENT_ID);
    private static final String DEFAULT_EXPUNGED_EVENT_JSON = "{  \"Expunged\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"expunged\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"sessionId\": 42,    \"user\": \"user\"  }}";

    ExpungedSerializationTest() {
    }

    @Test
    void expungedShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)DEFAULT_EXPUNGED_EVENT)).isEqualTo((Object)DEFAULT_EXPUNGED_EVENT_JSON);
    }

    @Test
    void expungedShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(DEFAULT_EXPUNGED_EVENT_JSON).get())).isEqualTo((Object)DEFAULT_EXPUNGED_EVENT);
    }

    @Nested
    class DeserializationErrors {
        DeserializationErrors() {
        }

        @Test
        void expungedShouldThrowWhenMissingSessionId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Expunged\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"expunged\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void expungedShouldThrowWhenMissingEventId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Expunged\": {    \"sessionId\":42,    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"expunged\": {},    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void expungedShouldThrowWhenMissingUser() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Expunged\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"expunged\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"sessionId\": 42  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void expungedShouldThrowWhenMissingMailboxId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Expunged\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"expunged\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"sessionId\": 42,    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void expungedShouldThrowWhenMissingPath() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Expunged\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxId\": \"18\",    \"expunged\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"sessionId\": 42,    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void expungedShouldThrowWhenMapKeyIsNull() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Expunged\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"Expunged\": null,    \"sessionId\": 42,    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void expungedShouldThrowWhenMissingExpunged() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Expunged\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"sessionId\": 42,    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }
    }

    @Nested
    class WithEmptyExpungedMap {
        private final MailboxEvents.Expunged emptyExpungedEvent = new MailboxEvents.Expunged(SESSION_ID, USERNAME, MAILBOX_PATH, MAILBOX_ID, (Map)ImmutableMap.of(), SerializerFixture.EVENT_ID);
        private final String emptyExpungedEventJson = "{  \"Expunged\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"expunged\": {},    \"sessionId\": 42,    \"user\": \"user\"  }}";

        WithEmptyExpungedMap() {
        }

        @Test
        void expungedShouldBeWellSerializedWhenMapKeyIsEmpty() {
            JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)this.emptyExpungedEvent)).isEqualTo((Object)"{  \"Expunged\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"expunged\": {},    \"sessionId\": 42,    \"user\": \"user\"  }}");
        }

        @Test
        void expungedShouldBeWellDeSerializedWhenMapKeyIsEmpty() {
            Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Expunged\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"expunged\": {},    \"sessionId\": 42,    \"user\": \"user\"  }}").get())).isEqualTo((Object)this.emptyExpungedEvent);
        }
    }
}

