/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.search;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.backends.es.AliasName;
import org.apache.james.backends.es.ReadAliasName;
import org.apache.james.backends.es.TypeName;
import org.apache.james.backends.es.search.ScrollIterable;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.elasticsearch.query.QueryConverter;
import org.apache.james.mailbox.elasticsearch.query.SortConverter;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.util.streams.Iterators;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.sort.SortBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchSearcher {
    public static final int DEFAULT_SEARCH_SIZE = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchSearcher.class);
    private static final TimeValue TIMEOUT = new TimeValue(60000L);
    private final Client client;
    private final QueryConverter queryConverter;
    private final int size;
    private final MailboxId.Factory mailboxIdFactory;
    private final MessageId.Factory messageIdFactory;
    private final AliasName aliasName;
    private final TypeName typeName;

    public ElasticSearchSearcher(Client client, QueryConverter queryConverter, int size, MailboxId.Factory mailboxIdFactory, MessageId.Factory messageIdFactory, ReadAliasName aliasName, TypeName typeName) {
        this.client = client;
        this.queryConverter = queryConverter;
        this.size = size;
        this.mailboxIdFactory = mailboxIdFactory;
        this.messageIdFactory = messageIdFactory;
        this.aliasName = aliasName;
        this.typeName = typeName;
    }

    public Stream<MessageSearchIndex.SearchResult> search(Collection<MailboxId> mailboxIds, SearchQuery query, Optional<Long> limit) throws MailboxException {
        SearchRequestBuilder searchRequestBuilder = this.getSearchRequestBuilder(this.client, mailboxIds, query, limit);
        Stream pairStream = new ScrollIterable(this.client, searchRequestBuilder).stream().flatMap(this::transformResponseToUidStream);
        return limit.map(pairStream::limit).orElse(pairStream);
    }

    private SearchRequestBuilder getSearchRequestBuilder(Client client, Collection<MailboxId> users, SearchQuery query, Optional<Long> limit) {
        return query.getSorts().stream().reduce(client.prepareSearch(new String[]{this.aliasName.getValue()}).setTypes(new String[]{this.typeName.getValue()}).setScroll(TIMEOUT).addFields(new String[]{"uid", "mailboxId", "messageId"}).setQuery(this.queryConverter.from(users, query)).setSize(this.computeRequiredSize(limit)), (searchBuilder, sort) -> searchBuilder.addSort((SortBuilder)SortConverter.convertSort(sort)), (partialResult1, partialResult2) -> partialResult1);
    }

    private int computeRequiredSize(Optional<Long> limit) {
        return limit.map(value -> Math.min(value.intValue(), this.size)).orElse(this.size);
    }

    private Stream<MessageSearchIndex.SearchResult> transformResponseToUidStream(SearchResponse searchResponse) {
        return Iterators.toStream((Iterator)searchResponse.getHits().iterator()).map(this::extractContentFromHit).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<MessageSearchIndex.SearchResult> extractContentFromHit(SearchHit hit) {
        SearchHitField mailboxId = hit.field("mailboxId");
        SearchHitField uid = hit.field("uid");
        Optional<SearchHitField> id = this.retrieveMessageIdField(hit);
        if (mailboxId != null && uid != null) {
            Number uidAsNumber = (Number)uid.getValue();
            return Optional.of(new MessageSearchIndex.SearchResult(id.map(field -> this.messageIdFactory.fromString((String)field.getValue())), this.mailboxIdFactory.fromString((String)mailboxId.getValue()), MessageUid.of((long)uidAsNumber.longValue())));
        }
        LOGGER.warn("Can not extract UID, MessageID and/or MailboxId for search result {}", (Object)hit.getId());
        return Optional.empty();
    }

    private Optional<SearchHitField> retrieveMessageIdField(SearchHit hit) {
        if (hit.fields().keySet().contains("messageId")) {
            return Optional.ofNullable(hit.field("messageId"));
        }
        return Optional.empty();
    }
}

