/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.query;

import org.apache.james.mailbox.model.SearchQuery;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class SortConverter {
    private static final String MIN = "min";
    private static final String PATH_SEPARATOR = ".";

    public static FieldSortBuilder convertSort(SearchQuery.Sort sort) {
        return SortConverter.getSortClause(sort.getSortClause()).order(SortConverter.getOrder(sort)).sortMode(MIN);
    }

    private static FieldSortBuilder getSortClause(SearchQuery.Sort.SortClause clause) {
        switch (clause) {
            case Arrival: {
                return SortBuilders.fieldSort((String)"date");
            }
            case MailboxCc: {
                return SortBuilders.fieldSort((String)"cc.address").setNestedPath("cc");
            }
            case MailboxFrom: {
                return SortBuilders.fieldSort((String)"from.address").setNestedPath("from");
            }
            case MailboxTo: {
                return SortBuilders.fieldSort((String)"to.address").setNestedPath("to");
            }
            case BaseSubject: {
                return SortBuilders.fieldSort((String)"subject.raw");
            }
            case Size: {
                return SortBuilders.fieldSort((String)"size");
            }
            case SentDate: {
                return SortBuilders.fieldSort((String)"sentDate");
            }
            case Uid: {
                return SortBuilders.fieldSort((String)"uid");
            }
            case DisplayFrom: {
                return SortBuilders.fieldSort((String)"from.name.raw").setNestedPath("from");
            }
            case DisplayTo: {
                return SortBuilders.fieldSort((String)"to.name.raw").setNestedPath("to");
            }
            case Id: {
                return SortBuilders.fieldSort((String)"messageId");
            }
        }
        throw new RuntimeException("Sort is not implemented");
    }

    private static SortOrder getOrder(SearchQuery.Sort sort) {
        if (sort.isReverse()) {
            return SortOrder.DESC;
        }
        return SortOrder.ASC;
    }
}

