/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.mail.Flags;

public class MessageUpdateJson {
    private final Flags flags;
    private final long modSeq;

    public MessageUpdateJson(Flags flags, long modSeq) {
        this.flags = flags;
        this.modSeq = modSeq;
    }

    @JsonProperty(value="isAnswered")
    public boolean isAnswered() {
        return this.flags.contains(Flags.Flag.ANSWERED);
    }

    @JsonProperty(value="isDeleted")
    public boolean isDeleted() {
        return this.flags.contains(Flags.Flag.DELETED);
    }

    @JsonProperty(value="isDraft")
    public boolean isDraft() {
        return this.flags.contains(Flags.Flag.DRAFT);
    }

    @JsonProperty(value="isFlagged")
    public boolean isFlagged() {
        return this.flags.contains(Flags.Flag.FLAGGED);
    }

    @JsonProperty(value="isRecent")
    public boolean isRecent() {
        return this.flags.contains(Flags.Flag.RECENT);
    }

    @JsonProperty(value="isUnread")
    public boolean isUnRead() {
        return !this.flags.contains(Flags.Flag.SEEN);
    }

    @JsonProperty(value="userFlags")
    public String[] getUserFlags() {
        return this.flags.getUserFlags();
    }

    @JsonProperty(value="modSeq")
    public long getModSeq() {
        return this.modSeq;
    }
}

