/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.base.Preconditions;
import java.time.ZoneId;
import java.util.List;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.core.User;
import org.apache.james.mailbox.elasticsearch.IndexAttachments;
import org.apache.james.mailbox.elasticsearch.json.IndexableMessage;
import org.apache.james.mailbox.elasticsearch.json.MessageUpdateJson;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class MessageToElasticSearchJson {
    private final ObjectMapper mapper;
    private final TextExtractor textExtractor;
    private final ZoneId zoneId;
    private final IndexAttachments indexAttachments;

    public MessageToElasticSearchJson(TextExtractor textExtractor, ZoneId zoneId, IndexAttachments indexAttachments) {
        this.textExtractor = textExtractor;
        this.zoneId = zoneId;
        this.indexAttachments = indexAttachments;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new GuavaModule());
        this.mapper.registerModule((Module)new Jdk8Module());
    }

    @Inject
    public MessageToElasticSearchJson(TextExtractor textExtractor, IndexAttachments indexAttachments) {
        this(textExtractor, ZoneId.systemDefault(), indexAttachments);
    }

    public String convertToJson(MailboxMessage message, List<User> users) throws JsonProcessingException {
        Preconditions.checkNotNull((Object)message);
        return this.mapper.writeValueAsString((Object)IndexableMessage.builder().message(message).users(users).extractor(this.textExtractor).zoneId(this.zoneId).indexAttachments(this.indexAttachments).build());
    }

    public String convertToJsonWithoutAttachment(MailboxMessage message, List<User> users) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)IndexableMessage.builder().message(message).users(users).extractor(this.textExtractor).zoneId(this.zoneId).indexAttachments(IndexAttachments.NO).build());
    }

    public String getUpdatedJsonMessagePart(Flags flags, long modSeq) throws JsonProcessingException {
        Preconditions.checkNotNull((Object)flags);
        return this.mapper.writeValueAsString((Object)new MessageUpdateJson(flags, modSeq));
    }
}

