/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.james.mailbox.elasticsearch.json.EMailer;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.apache.james.mailbox.store.search.comparator.SentDateComparator;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.field.address.LenientAddressParser;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.util.MimeUtil;

public class HeaderCollection {
    public static final String TO = "to";
    public static final String FROM = "from";
    public static final String CC = "cc";
    public static final String BCC = "bcc";
    public static final String REPLY_TO = "reply-to";
    public static final String SUBJECT = "subject";
    public static final String DATE = "date";
    public static final String MESSAGE_ID = "message-id";
    private final ImmutableSet<EMailer> toAddressSet;
    private final ImmutableSet<EMailer> fromAddressSet;
    private final ImmutableSet<EMailer> ccAddressSet;
    private final ImmutableSet<EMailer> bccAddressSet;
    private final ImmutableSet<EMailer> replyToAddressSet;
    private final ImmutableSet<String> subjectSet;
    private final ImmutableMultimap<String, String> headers;
    private final Optional<ZonedDateTime> sentDate;
    private final Optional<String> messageID;

    public static Builder builder() {
        return new Builder();
    }

    private HeaderCollection(ImmutableSet<EMailer> toAddressSet, ImmutableSet<EMailer> fromAddressSet, ImmutableSet<EMailer> ccAddressSet, ImmutableSet<EMailer> bccAddressSet, ImmutableSet<EMailer> replyToAddressSet, ImmutableSet<String> subjectSet, ImmutableMultimap<String, String> headers, Optional<ZonedDateTime> sentDate, Optional<String> messageID) {
        this.toAddressSet = toAddressSet;
        this.fromAddressSet = fromAddressSet;
        this.ccAddressSet = ccAddressSet;
        this.bccAddressSet = bccAddressSet;
        this.replyToAddressSet = replyToAddressSet;
        this.subjectSet = subjectSet;
        this.headers = headers;
        this.sentDate = sentDate;
        this.messageID = messageID;
    }

    public Set<EMailer> getToAddressSet() {
        return this.toAddressSet;
    }

    public Set<EMailer> getFromAddressSet() {
        return this.fromAddressSet;
    }

    public Set<EMailer> getCcAddressSet() {
        return this.ccAddressSet;
    }

    public Set<EMailer> getBccAddressSet() {
        return this.bccAddressSet;
    }

    public Set<EMailer> getReplyToAddressSet() {
        return this.replyToAddressSet;
    }

    public Set<String> getSubjectSet() {
        return this.subjectSet;
    }

    public Optional<ZonedDateTime> getSentDate() {
        return this.sentDate;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public Optional<String> getMessageID() {
        return this.messageID;
    }

    public static class Builder {
        private final Set<EMailer> toAddressSet = new HashSet<EMailer>();
        private final Set<EMailer> fromAddressSet = new HashSet<EMailer>();
        private final Set<EMailer> ccAddressSet = new HashSet<EMailer>();
        private final Set<EMailer> bccAddressSet = new HashSet<EMailer>();
        private final Set<EMailer> replyToAddressSet = new HashSet<EMailer>();
        private final Set<String> subjectSet = new HashSet<String>();
        private final Multimap<String, String> headers = ArrayListMultimap.create();
        private Optional<ZonedDateTime> sentDate = Optional.empty();
        private Optional<String> messageID = Optional.empty();

        private Builder() {
        }

        public Builder add(Field field) {
            Preconditions.checkNotNull((Object)field);
            String headerName = field.getName().toLowerCase(Locale.US);
            String sanitizedValue = MimeUtil.unscrambleHeaderValue((String)field.getBody());
            if (!headerName.contains(".")) {
                this.headers.put((Object)headerName, (Object)sanitizedValue);
            }
            this.handleSpecificHeader(headerName, sanitizedValue);
            return this;
        }

        public HeaderCollection build() {
            return new HeaderCollection(ImmutableSet.copyOf(this.toAddressSet), ImmutableSet.copyOf(this.fromAddressSet), ImmutableSet.copyOf(this.ccAddressSet), ImmutableSet.copyOf(this.bccAddressSet), ImmutableSet.copyOf(this.replyToAddressSet), ImmutableSet.copyOf(this.subjectSet), ImmutableMultimap.copyOf(this.headers), this.sentDate, this.messageID);
        }

        private void handleSpecificHeader(String headerName, String headerValue) {
            switch (headerName) {
                case "to": 
                case "from": 
                case "cc": 
                case "bcc": 
                case "reply-to": {
                    this.manageAddressField(headerName, headerValue);
                    break;
                }
                case "subject": {
                    this.subjectSet.add(headerValue);
                    break;
                }
                case "date": {
                    this.sentDate = SentDateComparator.toISODate((String)headerValue);
                    break;
                }
                case "message-id": {
                    this.messageID = Optional.ofNullable(headerValue);
                }
            }
        }

        private void manageAddressField(String headerName, String headerValue) {
            LenientAddressParser.DEFAULT.parseAddressList((CharSequence)headerValue).stream().flatMap(this::convertAddressToMailboxStream).map(mailbox -> new EMailer(SearchUtil.getDisplayAddress((Mailbox)mailbox), mailbox.getAddress())).collect(Collectors.toCollection(() -> this.getAddressSet(headerName)));
        }

        private Stream<Mailbox> convertAddressToMailboxStream(Address address) {
            if (address instanceof Mailbox) {
                return Stream.of((Mailbox)address);
            }
            if (address instanceof Group) {
                return ((Group)address).getMailboxes().stream();
            }
            return Stream.empty();
        }

        private Set<EMailer> getAddressSet(String headerName) {
            switch (headerName) {
                case "to": {
                    return this.toAddressSet;
                }
                case "from": {
                    return this.fromAddressSet;
                }
                case "cc": {
                    return this.ccAddressSet;
                }
                case "bcc": {
                    return this.bccAddressSet;
                }
                case "reply-to": {
                    return this.replyToAddressSet;
                }
            }
            throw new RuntimeException(headerName + " is not a address header name");
        }
    }
}

