/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.backends.es.ElasticSearchIndexer;
import org.apache.james.backends.es.UpdatedRepresentation;
import org.apache.james.core.User;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.elasticsearch.json.MessageToElasticSearchJson;
import org.apache.james.mailbox.elasticsearch.search.ElasticSearchSearcher;
import org.apache.james.mailbox.events.Group;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchListeningMessageSearchIndex
extends ListeningMessageSearchIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchListeningMessageSearchIndex.class);
    private static final String ID_SEPARATOR = ":";
    private static final Group GROUP = new ElasticSearchListeningMessageSearchIndexGroup();
    private final ElasticSearchIndexer elasticSearchIndexer;
    private final ElasticSearchSearcher searcher;
    private final MessageToElasticSearchJson messageToElasticSearchJson;

    @Inject
    public ElasticSearchListeningMessageSearchIndex(MailboxSessionMapperFactory factory, @Named(value="mailbox") ElasticSearchIndexer indexer, ElasticSearchSearcher searcher, MessageToElasticSearchJson messageToElasticSearchJson, SessionProvider sessionProvider) {
        super(factory, sessionProvider);
        this.elasticSearchIndexer = indexer;
        this.messageToElasticSearchJson = messageToElasticSearchJson;
        this.searcher = searcher;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities) {
        return EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch, new MailboxManager.SearchCapabilities[]{MailboxManager.SearchCapabilities.Text, MailboxManager.SearchCapabilities.FullText, MailboxManager.SearchCapabilities.Attachment, MailboxManager.SearchCapabilities.AttachmentFileName, MailboxManager.SearchCapabilities.PartialEmailMatch});
    }

    public Iterator<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) throws MailboxException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        Optional<Long> noLimit = Optional.empty();
        return this.searcher.search((Collection<MailboxId>)ImmutableList.of((Object)mailbox.getMailboxId()), searchQuery, noLimit).map(MessageSearchIndex.SearchResult::getMessageUid).iterator();
    }

    public List<MessageId> search(MailboxSession session, Collection<MailboxId> mailboxIds, SearchQuery searchQuery, long limit) throws MailboxException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        if (mailboxIds.isEmpty()) {
            return ImmutableList.of();
        }
        return (List)this.searcher.search(mailboxIds, searchQuery, Optional.empty()).peek(this::logIfNoMessageId).map(MessageSearchIndex.SearchResult::getMessageId).map(Optional::get).distinct().limit(limit).collect(Guavate.toImmutableList());
    }

    public void add(MailboxSession session, Mailbox mailbox, MailboxMessage message) throws JsonProcessingException {
        LOGGER.info("Indexing mailbox {}-{} of user {} on message {}", new Object[]{mailbox.getName(), mailbox.getMailboxId(), session.getUser().asString(), message.getUid()});
        String jsonContent = this.generateIndexedJson(mailbox, message, session);
        this.elasticSearchIndexer.index(this.indexIdFor(mailbox, message.getUid()), jsonContent);
    }

    private String generateIndexedJson(Mailbox mailbox, MailboxMessage message, MailboxSession session) throws JsonProcessingException {
        try {
            return this.messageToElasticSearchJson.convertToJson(message, (List<User>)ImmutableList.of((Object)session.getUser()));
        }
        catch (Exception e) {
            LOGGER.warn("Indexing mailbox {}-{} of user {} on message {} without attachments ", new Object[]{mailbox.getName(), mailbox.getMailboxId().serialize(), session.getUser().asString(), message.getUid(), e});
            return this.messageToElasticSearchJson.convertToJsonWithoutAttachment(message, (List<User>)ImmutableList.of((Object)session.getUser()));
        }
    }

    public void delete(MailboxSession session, Mailbox mailbox, Collection<MessageUid> expungedUids) {
        this.elasticSearchIndexer.delete((List)expungedUids.stream().map(uid -> this.indexIdFor(mailbox, (MessageUid)uid)).collect(Guavate.toImmutableList()));
    }

    public void deleteAll(MailboxSession session, Mailbox mailbox) {
        this.elasticSearchIndexer.deleteAllMatchingQuery((QueryBuilder)QueryBuilders.termQuery((String)"mailboxId", (String)mailbox.getMailboxId().serialize()));
    }

    public void update(MailboxSession session, Mailbox mailbox, List<UpdatedFlags> updatedFlagsList) {
        this.elasticSearchIndexer.update((List)updatedFlagsList.stream().map(Throwing.function(updatedFlags -> this.createUpdatedDocumentPartFromUpdatedFlags(mailbox, (UpdatedFlags)updatedFlags)).sneakyThrow()).collect(Guavate.toImmutableList()));
    }

    private UpdatedRepresentation createUpdatedDocumentPartFromUpdatedFlags(Mailbox mailbox, UpdatedFlags updatedFlags) throws JsonProcessingException {
        return new UpdatedRepresentation(this.indexIdFor(mailbox, updatedFlags.getUid()), this.messageToElasticSearchJson.getUpdatedJsonMessagePart(updatedFlags.getNewFlags(), updatedFlags.getModSeq()));
    }

    private String indexIdFor(Mailbox mailbox, MessageUid uid) {
        return String.join((CharSequence)ID_SEPARATOR, mailbox.getMailboxId().serialize(), String.valueOf(uid.asLong()));
    }

    private void logIfNoMessageId(MessageSearchIndex.SearchResult searchResult) {
        if (!searchResult.getMessageId().isPresent()) {
            LOGGER.error("No messageUid for {} in mailbox {}", (Object)searchResult.getMessageUid(), (Object)searchResult.getMailboxId());
        }
    }

    private static class ElasticSearchListeningMessageSearchIndexGroup
    extends Group {
        private ElasticSearchListeningMessageSearchIndexGroup() {
        }
    }
}

