/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch;

import org.apache.james.backends.es.AliasName;
import org.apache.james.backends.es.ElasticSearchConfiguration;
import org.apache.james.backends.es.IndexCreationFactory;
import org.apache.james.backends.es.IndexName;
import org.apache.james.backends.es.NodeMappingFactory;
import org.apache.james.backends.es.ReadAliasName;
import org.apache.james.backends.es.TypeName;
import org.apache.james.backends.es.WriteAliasName;
import org.apache.james.mailbox.elasticsearch.MailboxElasticSearchConstants;
import org.apache.james.mailbox.elasticsearch.MailboxMappingFactory;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class MailboxIndexCreationUtil {
    public static Client prepareClient(Client client, ReadAliasName readAlias, WriteAliasName writeAlias, IndexName indexName, ElasticSearchConfiguration configuration) {
        return NodeMappingFactory.applyMapping((Client)new IndexCreationFactory(configuration).useIndex(indexName).addAlias((AliasName)readAlias).addAlias((AliasName)writeAlias).createIndexAndAliases(client), (IndexName)indexName, (TypeName)MailboxElasticSearchConstants.MESSAGE_TYPE, (XContentBuilder)MailboxMappingFactory.getMappingContent());
    }

    public static Client prepareDefaultClient(Client client, ElasticSearchConfiguration configuration) {
        return MailboxIndexCreationUtil.prepareClient(client, MailboxElasticSearchConstants.DEFAULT_MAILBOX_READ_ALIAS, MailboxElasticSearchConstants.DEFAULT_MAILBOX_WRITE_ALIAS, MailboxElasticSearchConstants.DEFAULT_MAILBOX_INDEX, configuration);
    }
}

