/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.james.backends.es.IndexName;
import org.apache.james.backends.es.ReadAliasName;
import org.apache.james.backends.es.WriteAliasName;
import org.apache.james.mailbox.elasticsearch.IndexAttachments;
import org.apache.james.mailbox.elasticsearch.MailboxElasticSearchConstants;
import org.apache.james.util.OptionalUtils;

public class ElasticSearchMailboxConfiguration {
    public static final String ELASTICSEARCH_HOSTS = "elasticsearch.hosts";
    public static final String ELASTICSEARCH_MASTER_HOST = "elasticsearch.masterHost";
    public static final String ELASTICSEARCH_PORT = "elasticsearch.port";
    public static final String ELASTICSEARCH_INDEX_NAME = "elasticsearch.index.name";
    public static final String ELASTICSEARCH_INDEX_MAILBOX_NAME = "elasticsearch.index.mailbox.name";
    public static final String ELASTICSEARCH_NB_REPLICA = "elasticsearch.nb.replica";
    public static final String ELASTICSEARCH_NB_SHARDS = "elasticsearch.nb.shards";
    public static final String ELASTICSEARCH_ALIAS_READ_NAME = "elasticsearch.alias.read.name";
    public static final String ELASTICSEARCH_ALIAS_WRITE_NAME = "elasticsearch.alias.write.name";
    public static final String ELASTICSEARCH_ALIAS_READ_MAILBOX_NAME = "elasticsearch.alias.read.mailbox.name";
    public static final String ELASTICSEARCH_ALIAS_WRITE_MAILBOX_NAME = "elasticsearch.alias.write.mailbox.name";
    public static final String ELASTICSEARCH_INDEX_QUOTA_RATIO_NAME = "elasticsearch.index.quota.ratio.name";
    public static final String ELASTICSEARCH_ALIAS_READ_QUOTA_RATIO_NAME = "elasticsearch.alias.read.quota.ratio.name";
    public static final String ELASTICSEARCH_ALIAS_WRITE_QUOTA_RATIO_NAME = "elasticsearch.alias.write.quota.ratio.name";
    public static final String ELASTICSEARCH_RETRY_CONNECTION_MIN_DELAY = "elasticsearch.retryConnection.minDelay";
    public static final String ELASTICSEARCH_RETRY_CONNECTION_MAX_RETRIES = "elasticsearch.retryConnection.maxRetries";
    public static final String ELASTICSEARCH_INDEX_ATTACHMENTS = "elasticsearch.indexAttachments";
    public static final int DEFAULT_CONNECTION_MAX_RETRIES = 7;
    public static final int DEFAULT_CONNECTION_MIN_DELAY = 3000;
    public static final boolean DEFAULT_INDEX_ATTACHMENTS = true;
    public static final int DEFAULT_NB_SHARDS = 5;
    public static final int DEFAULT_NB_REPLICA = 1;
    public static final int DEFAULT_PORT = 9300;
    public static final Optional<Integer> DEFAULT_PORT_AS_OPTIONAL = Optional.of(9300);
    public static final ElasticSearchMailboxConfiguration DEFAULT_CONFIGURATION = ElasticSearchMailboxConfiguration.builder().build();
    private final IndexName indexMailboxName;
    private final ReadAliasName readAliasMailboxName;
    private final WriteAliasName writeAliasMailboxName;
    private final IndexAttachments indexAttachment;

    public static Builder builder() {
        return new Builder();
    }

    public static ElasticSearchMailboxConfiguration fromProperties(Configuration configuration) {
        return ElasticSearchMailboxConfiguration.builder().indexMailboxName(ElasticSearchMailboxConfiguration.computeMailboxIndexName(configuration)).readAliasMailboxName(ElasticSearchMailboxConfiguration.computeMailboxReadAlias(configuration)).writeAliasMailboxName(ElasticSearchMailboxConfiguration.computeMailboxWriteAlias(configuration)).indexAttachment(ElasticSearchMailboxConfiguration.provideIndexAttachments(configuration)).build();
    }

    public static Optional<IndexName> computeMailboxIndexName(Configuration configuration) {
        return OptionalUtils.or((Optional[])new Optional[]{Optional.ofNullable(configuration.getString(ELASTICSEARCH_INDEX_MAILBOX_NAME)).map(IndexName::new), Optional.ofNullable(configuration.getString(ELASTICSEARCH_INDEX_NAME)).map(IndexName::new)});
    }

    public static Optional<WriteAliasName> computeMailboxWriteAlias(Configuration configuration) {
        return OptionalUtils.or((Optional[])new Optional[]{Optional.ofNullable(configuration.getString(ELASTICSEARCH_ALIAS_WRITE_MAILBOX_NAME)).map(WriteAliasName::new), Optional.ofNullable(configuration.getString(ELASTICSEARCH_ALIAS_WRITE_NAME)).map(WriteAliasName::new)});
    }

    public static Optional<ReadAliasName> computeMailboxReadAlias(Configuration configuration) {
        return OptionalUtils.or((Optional[])new Optional[]{Optional.ofNullable(configuration.getString(ELASTICSEARCH_ALIAS_READ_MAILBOX_NAME)).map(ReadAliasName::new), Optional.ofNullable(configuration.getString(ELASTICSEARCH_ALIAS_READ_NAME)).map(ReadAliasName::new)});
    }

    private static IndexAttachments provideIndexAttachments(Configuration configuration) {
        if (configuration.getBoolean(ELASTICSEARCH_INDEX_ATTACHMENTS, true)) {
            return IndexAttachments.YES;
        }
        return IndexAttachments.NO;
    }

    private ElasticSearchMailboxConfiguration(IndexName indexMailboxName, ReadAliasName readAliasMailboxName, WriteAliasName writeAliasMailboxName, IndexAttachments indexAttachment) {
        this.indexMailboxName = indexMailboxName;
        this.readAliasMailboxName = readAliasMailboxName;
        this.writeAliasMailboxName = writeAliasMailboxName;
        this.indexAttachment = indexAttachment;
    }

    public IndexName getIndexMailboxName() {
        return this.indexMailboxName;
    }

    public ReadAliasName getReadAliasMailboxName() {
        return this.readAliasMailboxName;
    }

    public WriteAliasName getWriteAliasMailboxName() {
        return this.writeAliasMailboxName;
    }

    public IndexAttachments getIndexAttachment() {
        return this.indexAttachment;
    }

    public final boolean equals(Object o) {
        if (o instanceof ElasticSearchMailboxConfiguration) {
            ElasticSearchMailboxConfiguration that = (ElasticSearchMailboxConfiguration)o;
            return Objects.equals((Object)this.indexAttachment, (Object)that.indexAttachment) && Objects.equals(this.indexMailboxName, that.indexMailboxName) && Objects.equals(this.readAliasMailboxName, that.readAliasMailboxName) && Objects.equals(this.writeAliasMailboxName, that.writeAliasMailboxName);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.indexMailboxName, this.readAliasMailboxName, this.writeAliasMailboxName, this.indexAttachment, this.writeAliasMailboxName});
    }

    public static class Builder {
        private Optional<IndexName> indexMailboxName = Optional.empty();
        private Optional<ReadAliasName> readAliasMailboxName = Optional.empty();
        private Optional<WriteAliasName> writeAliasMailboxName = Optional.empty();
        private Optional<IndexAttachments> indexAttachment = Optional.empty();

        public Builder indexMailboxName(IndexName indexMailboxName) {
            return this.indexMailboxName(Optional.of(indexMailboxName));
        }

        public Builder indexMailboxName(Optional<IndexName> indexMailboxName) {
            this.indexMailboxName = indexMailboxName;
            return this;
        }

        public Builder readAliasMailboxName(ReadAliasName readAliasMailboxName) {
            return this.readAliasMailboxName(Optional.of(readAliasMailboxName));
        }

        public Builder readAliasMailboxName(Optional<ReadAliasName> readAliasMailboxName) {
            this.readAliasMailboxName = readAliasMailboxName;
            return this;
        }

        public Builder writeAliasMailboxName(WriteAliasName writeAliasMailboxName) {
            return this.writeAliasMailboxName(Optional.of(writeAliasMailboxName));
        }

        public Builder writeAliasMailboxName(Optional<WriteAliasName> writeAliasMailboxName) {
            this.writeAliasMailboxName = writeAliasMailboxName;
            return this;
        }

        public Builder indexAttachment(IndexAttachments indexAttachment) {
            this.indexAttachment = Optional.of(indexAttachment);
            return this;
        }

        public ElasticSearchMailboxConfiguration build() {
            return new ElasticSearchMailboxConfiguration(this.indexMailboxName.orElse(MailboxElasticSearchConstants.DEFAULT_MAILBOX_INDEX), this.readAliasMailboxName.orElse(MailboxElasticSearchConstants.DEFAULT_MAILBOX_READ_ALIAS), this.writeAliasMailboxName.orElse(MailboxElasticSearchConstants.DEFAULT_MAILBOX_WRITE_ALIAS), this.indexAttachment.orElse(IndexAttachments.YES));
        }
    }
}

