/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.query;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.elasticsearch.query.CriterionConverter;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class QueryConverter {
    private final CriterionConverter criterionConverter;

    @Inject
    public QueryConverter(CriterionConverter criterionConverter) {
        this.criterionConverter = criterionConverter;
    }

    public QueryBuilder from(List<MailboxSession.User> users, MultimailboxesSearchQuery query) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(this.generateQueryBuilder(query.getSearchQuery())).filter(this.usersQuery(users));
        this.mailboxesQuery((Collection<MailboxId>)query.getInMailboxes()).map(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).filter(arg_0));
        this.mailboxesQuery((Collection<MailboxId>)query.getNotInMailboxes()).map(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).mustNot(arg_0));
        return boolQueryBuilder;
    }

    private QueryBuilder generateQueryBuilder(SearchQuery searchQuery) {
        List criteria = searchQuery.getCriterias();
        if (criteria.isEmpty()) {
            return this.criterionConverter.convertCriterion(SearchQuery.all());
        }
        if (criteria.size() == 1) {
            return this.criterionConverter.convertCriterion((SearchQuery.Criterion)criteria.get(0));
        }
        return this.criterionConverter.convertCriterion((SearchQuery.Criterion)new SearchQuery.ConjunctionCriterion(SearchQuery.Conjunction.AND, criteria));
    }

    private QueryBuilder usersQuery(List<MailboxSession.User> users) {
        ImmutableList usernames = (ImmutableList)users.stream().map(MailboxSession.User::getUserName).collect(Guavate.toImmutableList());
        return QueryBuilders.termsQuery((String)"users", (Collection)usernames);
    }

    private Optional<QueryBuilder> mailboxesQuery(Collection<MailboxId> mailboxIds) {
        if (mailboxIds.isEmpty()) {
            return Optional.empty();
        }
        ImmutableList ids = (ImmutableList)mailboxIds.stream().map(MailboxId::serialize).collect(Guavate.toImmutableList());
        return Optional.of(QueryBuilders.termsQuery((String)"mailboxId", (Collection)ids));
    }
}

