/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.james.mailbox.elasticsearch.json.Serializable;

public class EMailer
implements Serializable {
    private final String name;
    private final String address;

    public EMailer(String name, String address) {
        this.name = name;
        this.address = address;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    @Override
    public String serialize() {
        return Joiner.on((String)" ").join((Object)this.name, (Object)this.address, new Object[0]);
    }

    public boolean equals(Object o) {
        if (o instanceof EMailer) {
            EMailer otherEMailer = (EMailer)o;
            return Objects.equals(this.name, otherEMailer.name) && Objects.equals(this.address, otherEMailer.address);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.address);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("address", (Object)this.address).toString();
    }
}

