/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.james.mailbox.elasticsearch.ClientProvider;
import org.apache.james.mailbox.elasticsearch.EmbeddedElasticSearch;
import org.apache.james.mailbox.elasticsearch.IndexCreationFactory;
import org.apache.james.mailbox.elasticsearch.NodeMappingFactory;
import org.apache.james.mailbox.elasticsearch.search.ScrollIterable;
import org.apache.james.mailbox.elasticsearch.utils.TestingClientProvider;
import org.assertj.core.api.Assertions;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class ScrollIterableTest {
    public static final TimeValue TIMEOUT = new TimeValue(6000L);
    public static final int SIZE = 2;
    public static final String MESSAGE = "message";
    private TemporaryFolder temporaryFolder = new TemporaryFolder();
    private EmbeddedElasticSearch embeddedElasticSearch = new EmbeddedElasticSearch(this.temporaryFolder);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.temporaryFolder).around((TestRule)this.embeddedElasticSearch);
    private ClientProvider clientProvider;

    @Before
    public void setUp() throws Exception {
        this.clientProvider = new TestingClientProvider(this.embeddedElasticSearch.getNode());
        IndexCreationFactory.createIndex((Client)this.clientProvider.get());
        this.embeddedElasticSearch.awaitForElasticSearch();
        NodeMappingFactory.applyMapping((Client)this.clientProvider.get(), (XContentBuilder)this.getMappingsSources());
    }

    private XContentBuilder getMappingsSources() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject(MESSAGE).startObject("properties").startObject(MESSAGE).field("type", "string").endObject().endObject().endObject().endObject();
    }

    @Test
    public void scrollIterableShouldWorkWhenEmpty() {
        try (Client client = this.clientProvider.get();){
            SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{MESSAGE}).setScroll(TIMEOUT).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(2);
            Assertions.assertThat((Iterable)new ScrollIterable(client, searchRequestBuilder)).isEmpty();
        }
    }

    @Test
    public void scrollIterableShouldWorkWhenOneElement() {
        try (Client client = this.clientProvider.get();){
            String id = "1";
            client.prepareIndex("mailbox", MESSAGE, id).setSource(MESSAGE, (Object)"Sample message").execute();
            this.embeddedElasticSearch.awaitForElasticSearch();
            SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{MESSAGE}).setScroll(TIMEOUT).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(2);
            Assertions.assertThat(this.convertToIdList(new ScrollIterable(client, searchRequestBuilder))).containsOnly((Object[])new String[]{id});
        }
    }

    @Test
    public void scrollIterableShouldWorkWhenSizeElement() {
        try (Client client = this.clientProvider.get();){
            String id1 = "1";
            client.prepareIndex("mailbox", MESSAGE, id1).setSource(MESSAGE, (Object)"Sample message").execute();
            String id2 = "2";
            client.prepareIndex("mailbox", MESSAGE, id2).setSource(MESSAGE, (Object)"Sample message").execute();
            this.embeddedElasticSearch.awaitForElasticSearch();
            SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{MESSAGE}).setScroll(TIMEOUT).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(2);
            Assertions.assertThat(this.convertToIdList(new ScrollIterable(client, searchRequestBuilder))).containsOnly((Object[])new String[]{id1, id2});
        }
    }

    @Test
    public void scrollIterableShouldWorkWhenMoreThanSizeElement() {
        try (Client client = this.clientProvider.get();){
            String id1 = "1";
            client.prepareIndex("mailbox", MESSAGE, id1).setSource(MESSAGE, (Object)"Sample message").execute();
            String id2 = "2";
            client.prepareIndex("mailbox", MESSAGE, id2).setSource(MESSAGE, (Object)"Sample message").execute();
            String id3 = "3";
            client.prepareIndex("mailbox", MESSAGE, id3).setSource(MESSAGE, (Object)"Sample message").execute();
            this.embeddedElasticSearch.awaitForElasticSearch();
            SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{MESSAGE}).setScroll(TIMEOUT).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(2);
            Assertions.assertThat(this.convertToIdList(new ScrollIterable(client, searchRequestBuilder))).containsOnly((Object[])new String[]{id1, id2, id3});
        }
    }

    private List<String> convertToIdList(ScrollIterable scrollIterable) {
        return scrollIterable.stream().flatMap(searchResponse -> Arrays.asList(searchResponse.getHits().getHits()).stream()).map(SearchHit::getId).collect(Collectors.toList());
    }
}

