/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.query;

import java.text.ParseException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.james.mailbox.elasticsearch.query.DateResolutionFormater;
import org.apache.james.mailbox.model.SearchQuery;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DateResolutionFormaterTest {
    private final String dateString = "2014-01-02T15:15:15Z";

    @Test
    public void calculateUpperDateShouldReturnDateUpToTheNextMinuteUsingMinuteUnit() throws ParseException {
        Assertions.assertThat((String)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormater.computeUpperDate((ZonedDateTime)ZonedDateTime.parse("2014-01-02T15:15:15Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME), (SearchQuery.DateResolution)SearchQuery.DateResolution.Minute))).isEqualTo((Object)"2014-01-02T15:16:00Z");
    }

    @Test
    public void calculateUpperDateShouldReturnDateUpToTheNextHourUsingHourUnit() throws ParseException {
        Assertions.assertThat((String)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormater.computeUpperDate((ZonedDateTime)ZonedDateTime.parse("2014-01-02T15:15:15Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME), (SearchQuery.DateResolution)SearchQuery.DateResolution.Hour))).isEqualTo((Object)"2014-01-02T16:00:00Z");
    }

    @Test
    public void calculateUpperDateShouldReturnDateUpToTheNextMonthUsingMonthUnit() throws ParseException {
        Assertions.assertThat((String)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormater.computeUpperDate((ZonedDateTime)ZonedDateTime.parse("2014-01-02T15:15:15Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME), (SearchQuery.DateResolution)SearchQuery.DateResolution.Month))).isEqualTo((Object)"2014-02-01T00:00:00Z");
    }

    @Test
    public void calculateUpperDateShouldReturnDateUpToTheNextYearUsingYearUnit() throws ParseException {
        Assertions.assertThat((String)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormater.computeUpperDate((ZonedDateTime)ZonedDateTime.parse("2014-01-02T15:15:15Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME), (SearchQuery.DateResolution)SearchQuery.DateResolution.Year))).isEqualTo((Object)"2015-01-01T00:00:00Z");
    }

    @Test
    public void calculateUpperDateShouldReturnDateUpToTheNextDayUsingDayUnit() throws ParseException {
        Assertions.assertThat((String)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormater.computeUpperDate((ZonedDateTime)ZonedDateTime.parse("2014-01-02T15:15:15Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day))).isEqualTo((Object)"2014-01-03T00:00:00Z");
    }

    @Test
    public void calculateLowerDateShouldReturnDateUpToThePreviousMinuteUsingMinuteUnit() throws ParseException {
        Assertions.assertThat((String)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormater.computeLowerDate((ZonedDateTime)ZonedDateTime.parse("2014-01-02T15:15:15Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME), (SearchQuery.DateResolution)SearchQuery.DateResolution.Minute))).isEqualTo((Object)"2014-01-02T15:15:00Z");
    }

    @Test
    public void calculateLowerDateShouldReturnDateUpToThePreviousDayUsingDayUnit() throws ParseException {
        Assertions.assertThat((String)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormater.computeLowerDate((ZonedDateTime)ZonedDateTime.parse("2014-01-02T15:15:15Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day))).isEqualTo((Object)"2014-01-02T00:00:00Z");
    }
}

