/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.james.mailbox.elasticsearch.json.Subjects;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SubjectsTest {
    @Test
    public void fromShouldThrowWhenSetIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Subjects.from(null)).isInstanceOf(NullPointerException.class)).hasMessage("'subjects' is mandatory");
    }

    @Test
    public void serializeShouldReturnEmptyWhenEmptySet() {
        Subjects subjects = Subjects.from((Set)ImmutableSet.of());
        Assertions.assertThat((String)subjects.serialize()).isEmpty();
    }

    @Test
    public void serializeShouldNotJoinWhenOneElement() {
        String expected = "subject";
        Subjects subjects = Subjects.from((Set)ImmutableSet.of((Object)expected));
        Assertions.assertThat((String)subjects.serialize()).isEqualTo((Object)expected);
    }

    @Test
    public void serializeShouldJoinWhenMultipleElements() {
        String subject = "subject";
        String subject2 = "subject2";
        String subject3 = "subject3";
        String expected = Joiner.on((String)" ").join((Object)subject, (Object)subject2, new Object[]{subject3});
        Subjects subjects = Subjects.from((Set)ImmutableSet.of((Object)subject, (Object)subject2, (Object)subject3));
        Assertions.assertThat((String)subjects.serialize()).isEqualTo((Object)expected);
    }
}

