/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.fluent.JsonFluentAssert;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.elasticsearch.json.MessageToElasticSearchJson;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.mock.MockMailboxSession;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.TestId;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.tika.extractor.TikaTextExtractor;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class MailboxMessageToElasticSearchJsonTest {
    public static final int SIZE = 25;
    public static final int BODY_START_OCTET = 100;
    public static final TestId MAILBOX_ID = TestId.of((long)18L);
    public static final MessageId MESSAGE_ID = new DefaultMessageId();
    public static final long MOD_SEQ = 42L;
    public static final MessageUid UID = MessageUid.of((long)25L);
    public static final Charset CHARSET = Charsets.UTF_8;
    private Date date;
    private PropertyBuilder propertyBuilder;

    @Before
    public void setUp() throws Exception {
        this.date = new Date(1433628000000L);
        this.propertyBuilder = new PropertyBuilder();
        this.propertyBuilder.setMediaType("plain");
        this.propertyBuilder.setSubType("text");
        this.propertyBuilder.setTextualLineCount(Long.valueOf(18L));
        this.propertyBuilder.setContentDescription("An e-mail");
    }

    @Test
    public void convertToJsonShouldThrowWhenNoUser() throws Exception {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        SimpleMailboxMessage spamMail = new SimpleMailboxMessage(MESSAGE_ID, this.date, 25L, 100, (SharedInputStream)new SharedByteArrayInputStream("message".getBytes(Charsets.UTF_8)), new Flags(), this.propertyBuilder, (MailboxId)MAILBOX_ID);
        ImmutableList users = ImmutableList.of();
        Assertions.assertThatThrownBy(() -> MailboxMessageToElasticSearchJsonTest.lambda$convertToJsonShouldThrowWhenNoUser$0(messageToElasticSearchJson, (MailboxMessage)spamMail, users)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void spamEmailShouldBeWellConvertedToJson() throws IOException {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        SimpleMailboxMessage spamMail = new SimpleMailboxMessage(MESSAGE_ID, this.date, 25L, 100, (SharedInputStream)new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream("eml/spamMail.eml"))), new Flags(), this.propertyBuilder, (MailboxId)MAILBOX_ID);
        spamMail.setUid(UID);
        spamMail.setModSeq(42L);
        JsonFluentAssert.assertThatJson((Object)messageToElasticSearchJson.convertToJson((MailboxMessage)spamMail, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()))).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)IOUtils.toString((URL)ClassLoader.getSystemResource("eml/spamMail.json"), (Charset)CHARSET));
    }

    @Test
    public void htmlEmailShouldBeWellConvertedToJson() throws IOException {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        SimpleMailboxMessage htmlMail = new SimpleMailboxMessage(MESSAGE_ID, this.date, 25L, 100, (SharedInputStream)new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream("eml/htmlMail.eml"))), new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.DELETED, Flags.Flag.SEEN}).add(new String[]{"social", "pocket-money"}).build(), this.propertyBuilder, (MailboxId)MAILBOX_ID);
        htmlMail.setModSeq(42L);
        htmlMail.setUid(UID);
        JsonFluentAssert.assertThatJson((Object)messageToElasticSearchJson.convertToJson((MailboxMessage)htmlMail, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()))).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)IOUtils.toString((URL)ClassLoader.getSystemResource("eml/htmlMail.json")));
    }

    @Test
    public void pgpSignedEmailShouldBeWellConvertedToJson() throws IOException {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        SimpleMailboxMessage pgpSignedMail = new SimpleMailboxMessage(MESSAGE_ID, this.date, 25L, 100, (SharedInputStream)new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream("eml/pgpSignedMail.eml"))), new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.DELETED, Flags.Flag.SEEN}).add(new String[]{"debian", "security"}).build(), this.propertyBuilder, (MailboxId)MAILBOX_ID);
        pgpSignedMail.setModSeq(42L);
        pgpSignedMail.setUid(UID);
        JsonFluentAssert.assertThatJson((Object)messageToElasticSearchJson.convertToJson((MailboxMessage)pgpSignedMail, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()))).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)IOUtils.toString((URL)ClassLoader.getSystemResource("eml/pgpSignedMail.json")));
    }

    @Test
    public void simpleEmailShouldBeWellConvertedToJson() throws IOException {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        SimpleMailboxMessage mail = new SimpleMailboxMessage(MESSAGE_ID, this.date, 25L, 100, (SharedInputStream)new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream("eml/mail.eml"))), new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.DELETED, Flags.Flag.SEEN}).add(new String[]{"debian", "security"}).build(), this.propertyBuilder, (MailboxId)MAILBOX_ID);
        mail.setModSeq(42L);
        mail.setUid(UID);
        JsonFluentAssert.assertThatJson((Object)messageToElasticSearchJson.convertToJson((MailboxMessage)mail, (List)ImmutableList.of((Object)new MockMailboxSession("user1").getUser(), (Object)new MockMailboxSession("user2").getUser()))).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).when(Option.IGNORING_VALUES, new Option[0]).isEqualTo((Object)IOUtils.toString((URL)ClassLoader.getSystemResource("eml/mail.json")));
    }

    @Test
    public void recursiveEmailShouldBeWellConvertedToJson() throws IOException {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        SimpleMailboxMessage recursiveMail = new SimpleMailboxMessage(MESSAGE_ID, this.date, 25L, 100, (SharedInputStream)new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream("eml/recursiveMail.eml"))), new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.DELETED, Flags.Flag.SEEN}).add(new String[]{"debian", "security"}).build(), this.propertyBuilder, (MailboxId)MAILBOX_ID);
        recursiveMail.setModSeq(42L);
        recursiveMail.setUid(UID);
        JsonFluentAssert.assertThatJson((Object)messageToElasticSearchJson.convertToJson((MailboxMessage)recursiveMail, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()))).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).when(Option.IGNORING_VALUES, new Option[0]).isEqualTo((Object)IOUtils.toString((URL)ClassLoader.getSystemResource("eml/recursiveMail.json")));
    }

    @Test
    public void emailWithNoInternalDateShouldUseNowDate() throws IOException {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        SimpleMailboxMessage mailWithNoInternalDate = new SimpleMailboxMessage(MESSAGE_ID, null, 25L, 100, (SharedInputStream)new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream("eml/recursiveMail.eml"))), new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.DELETED, Flags.Flag.SEEN}).add(new String[]{"debian", "security"}).build(), this.propertyBuilder, (MailboxId)MAILBOX_ID);
        mailWithNoInternalDate.setModSeq(42L);
        mailWithNoInternalDate.setUid(UID);
        JsonFluentAssert.assertThatJson((Object)messageToElasticSearchJson.convertToJson((MailboxMessage)mailWithNoInternalDate, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()))).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).when(Option.IGNORING_VALUES, new Option[0]).isEqualTo((Object)IOUtils.toString((URL)ClassLoader.getSystemResource("eml/recursiveMail.json")));
    }

    @Test(expected=NullPointerException.class)
    public void emailWithNoMailboxIdShouldThrow() throws IOException {
        SimpleMailboxMessage mailWithNoMailboxId;
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        try {
            mailWithNoMailboxId = new SimpleMailboxMessage(MESSAGE_ID, this.date, 25L, 100, (SharedInputStream)new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream("eml/recursiveMail.eml"))), new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.DELETED, Flags.Flag.SEEN}).add(new String[]{"debian", "security"}).build(), this.propertyBuilder, null);
            mailWithNoMailboxId.setModSeq(42L);
            mailWithNoMailboxId.setUid(UID);
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
        messageToElasticSearchJson.convertToJson((MailboxMessage)mailWithNoMailboxId, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()));
    }

    @Test
    public void getUpdatedJsonMessagePartShouldBehaveWellOnEmptyFlags() throws Exception {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        JsonFluentAssert.assertThatJson((Object)messageToElasticSearchJson.getUpdatedJsonMessagePart(new Flags(), 42L)).isEqualTo((Object)"{\"modSeq\":42,\"isAnswered\":false,\"isDeleted\":false,\"isDraft\":false,\"isFlagged\":false,\"isRecent\":false,\"userFlags\":[],\"isUnread\":true}");
    }

    @Test
    public void getUpdatedJsonMessagePartShouldBehaveWellOnNonEmptyFlags() throws Exception {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        JsonFluentAssert.assertThatJson((Object)messageToElasticSearchJson.getUpdatedJsonMessagePart(new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.DELETED, Flags.Flag.FLAGGED}).add(new String[]{"user"}).build(), 42L)).isEqualTo((Object)"{\"modSeq\":42,\"isAnswered\":false,\"isDeleted\":true,\"isDraft\":false,\"isFlagged\":true,\"isRecent\":false,\"userFlags\":[\"user\"],\"isUnread\":true}");
    }

    @Test(expected=NullPointerException.class)
    public void getUpdatedJsonMessagePartShouldThrowIfFlagsIsNull() throws Exception {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris"));
        messageToElasticSearchJson.getUpdatedJsonMessagePart(null, 42L);
    }

    @Test
    public void spamEmailShouldBeWellConvertedToJsonWithApacheTika() throws IOException {
        MessageToElasticSearchJson messageToElasticSearchJson = new MessageToElasticSearchJson((TextExtractor)new TikaTextExtractor(), ZoneId.of("Europe/Paris"));
        SimpleMailboxMessage spamMail = new SimpleMailboxMessage(MESSAGE_ID, this.date, 25L, 100, (SharedInputStream)new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream("eml/nonTextual.eml"))), new Flags(), this.propertyBuilder, (MailboxId)MAILBOX_ID);
        spamMail.setUid(UID);
        spamMail.setModSeq(42L);
        JsonFluentAssert.assertThatJson((Object)messageToElasticSearchJson.convertToJson((MailboxMessage)spamMail, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()))).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)IOUtils.toString((URL)ClassLoader.getSystemResource("eml/nonTextual.json"), (Charset)CHARSET));
    }

    private static /* synthetic */ void lambda$convertToJsonShouldThrowWhenNoUser$0(MessageToElasticSearchJson messageToElasticSearchJson, MailboxMessage spamMail, ImmutableList users) throws Throwable {
        messageToElasticSearchJson.convertToJson(spamMail, (List)users);
    }
}

