/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.List;
import javax.mail.Flags;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.elasticsearch.json.IndexableMessage;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.mock.MockMailboxSession;
import org.apache.james.mailbox.store.TestId;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class IndexableMessageTest {
    @Test
    public void textShouldBeEmptyWhenNoMatchingHeaders() throws Exception {
        MailboxMessage mailboxMessage = (MailboxMessage)Mockito.mock(MailboxMessage.class);
        TestId mailboxId = TestId.of((long)1L);
        Mockito.when((Object)mailboxMessage.getMailboxId()).thenReturn((Object)mailboxId);
        Mockito.when((Object)mailboxMessage.getFullContent()).thenReturn((Object)new ByteArrayInputStream("".getBytes()));
        Mockito.when((Object)mailboxMessage.createFlags()).thenReturn((Object)new Flags());
        IndexableMessage indexableMessage = IndexableMessage.from((MailboxMessage)mailboxMessage, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()), (TextExtractor)new DefaultTextExtractor(), (ZoneId)ZoneId.of("Europe/Paris"));
        Assertions.assertThat((String)indexableMessage.getText()).isEmpty();
    }

    @Test
    public void textShouldContainsFromWhenFrom() throws Exception {
        MailboxMessage mailboxMessage = (MailboxMessage)Mockito.mock(MailboxMessage.class);
        TestId mailboxId = TestId.of((long)1L);
        Mockito.when((Object)mailboxMessage.getMailboxId()).thenReturn((Object)mailboxId);
        Mockito.when((Object)mailboxMessage.getFullContent()).thenReturn((Object)new ByteArrayInputStream("From: First user <user@james.org>\nFrom: Second user <user2@james.org>".getBytes()));
        Mockito.when((Object)mailboxMessage.createFlags()).thenReturn((Object)new Flags());
        IndexableMessage indexableMessage = IndexableMessage.from((MailboxMessage)mailboxMessage, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()), (TextExtractor)new DefaultTextExtractor(), (ZoneId)ZoneId.of("Europe/Paris"));
        Assertions.assertThat((String)indexableMessage.getText()).isEqualTo((Object)"Second user user2@james.org First user user@james.org");
    }

    @Test
    public void textShouldContainsToWhenTo() throws Exception {
        MailboxMessage mailboxMessage = (MailboxMessage)Mockito.mock(MailboxMessage.class);
        TestId mailboxId = TestId.of((long)1L);
        Mockito.when((Object)mailboxMessage.getMailboxId()).thenReturn((Object)mailboxId);
        Mockito.when((Object)mailboxMessage.getFullContent()).thenReturn((Object)new ByteArrayInputStream("To: First to <user@james.org>\nTo: Second to <user2@james.org>".getBytes()));
        Mockito.when((Object)mailboxMessage.createFlags()).thenReturn((Object)new Flags());
        IndexableMessage indexableMessage = IndexableMessage.from((MailboxMessage)mailboxMessage, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()), (TextExtractor)new DefaultTextExtractor(), (ZoneId)ZoneId.of("Europe/Paris"));
        Assertions.assertThat((String)indexableMessage.getText()).isEqualTo((Object)"First to user@james.org Second to user2@james.org");
    }

    @Test
    public void textShouldContainsCcWhenCc() throws Exception {
        MailboxMessage mailboxMessage = (MailboxMessage)Mockito.mock(MailboxMessage.class);
        TestId mailboxId = TestId.of((long)1L);
        Mockito.when((Object)mailboxMessage.getMailboxId()).thenReturn((Object)mailboxId);
        Mockito.when((Object)mailboxMessage.getFullContent()).thenReturn((Object)new ByteArrayInputStream("Cc: First cc <user@james.org>\nCc: Second cc <user2@james.org>".getBytes()));
        Mockito.when((Object)mailboxMessage.createFlags()).thenReturn((Object)new Flags());
        IndexableMessage indexableMessage = IndexableMessage.from((MailboxMessage)mailboxMessage, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()), (TextExtractor)new DefaultTextExtractor(), (ZoneId)ZoneId.of("Europe/Paris"));
        Assertions.assertThat((String)indexableMessage.getText()).isEqualTo((Object)"First cc user@james.org Second cc user2@james.org");
    }

    @Test
    public void textShouldContainsBccWhenBcc() throws Exception {
        MailboxMessage mailboxMessage = (MailboxMessage)Mockito.mock(MailboxMessage.class);
        TestId mailboxId = TestId.of((long)1L);
        Mockito.when((Object)mailboxMessage.getMailboxId()).thenReturn((Object)mailboxId);
        Mockito.when((Object)mailboxMessage.getFullContent()).thenReturn((Object)new ByteArrayInputStream("Bcc: First bcc <user@james.org>\nBcc: Second bcc <user2@james.org>".getBytes()));
        Mockito.when((Object)mailboxMessage.createFlags()).thenReturn((Object)new Flags());
        IndexableMessage indexableMessage = IndexableMessage.from((MailboxMessage)mailboxMessage, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()), (TextExtractor)new DefaultTextExtractor(), (ZoneId)ZoneId.of("Europe/Paris"));
        Assertions.assertThat((String)indexableMessage.getText()).isEqualTo((Object)"Second bcc user2@james.org First bcc user@james.org");
    }

    @Test
    public void textShouldContainsSubjectsWhenSubjects() throws Exception {
        MailboxMessage mailboxMessage = (MailboxMessage)Mockito.mock(MailboxMessage.class);
        TestId mailboxId = TestId.of((long)1L);
        Mockito.when((Object)mailboxMessage.getMailboxId()).thenReturn((Object)mailboxId);
        Mockito.when((Object)mailboxMessage.getFullContent()).thenReturn((Object)new ByteArrayInputStream("Subject: subject1\nSubject: subject2".getBytes()));
        Mockito.when((Object)mailboxMessage.createFlags()).thenReturn((Object)new Flags());
        IndexableMessage indexableMessage = IndexableMessage.from((MailboxMessage)mailboxMessage, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()), (TextExtractor)new DefaultTextExtractor(), (ZoneId)ZoneId.of("Europe/Paris"));
        Assertions.assertThat((String)indexableMessage.getText()).isEqualTo((Object)"subject1 subject2");
    }

    @Test
    public void textShouldContainsBodyWhenBody() throws Exception {
        MailboxMessage mailboxMessage = (MailboxMessage)Mockito.mock(MailboxMessage.class);
        TestId mailboxId = TestId.of((long)1L);
        Mockito.when((Object)mailboxMessage.getMailboxId()).thenReturn((Object)mailboxId);
        Mockito.when((Object)mailboxMessage.getFullContent()).thenReturn((Object)new ByteArrayInputStream("\nMy body".getBytes()));
        Mockito.when((Object)mailboxMessage.createFlags()).thenReturn((Object)new Flags());
        IndexableMessage indexableMessage = IndexableMessage.from((MailboxMessage)mailboxMessage, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()), (TextExtractor)new DefaultTextExtractor(), (ZoneId)ZoneId.of("Europe/Paris"));
        Assertions.assertThat((String)indexableMessage.getText()).isEqualTo((Object)"My body");
    }

    @Test
    public void textShouldContainsAllFieldsWhenAllSet() throws Exception {
        MailboxMessage mailboxMessage = (MailboxMessage)Mockito.mock(MailboxMessage.class);
        TestId mailboxId = TestId.of((long)1L);
        Mockito.when((Object)mailboxMessage.getMailboxId()).thenReturn((Object)mailboxId);
        Mockito.when((Object)mailboxMessage.getFullContent()).thenReturn((Object)new ByteArrayInputStream(IOUtils.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream("eml/mailWithHeaders.eml"))));
        Mockito.when((Object)mailboxMessage.createFlags()).thenReturn((Object)new Flags());
        IndexableMessage indexableMessage = IndexableMessage.from((MailboxMessage)mailboxMessage, (List)ImmutableList.of((Object)new MockMailboxSession("username").getUser()), (TextExtractor)new DefaultTextExtractor(), (ZoneId)ZoneId.of("Europe/Paris"));
        Assertions.assertThat((String)indexableMessage.getText()).isEqualTo((Object)"Ad Min admin@opush.test a@test a@test B b@test c@test c@test dD d@test my subject Mail content\n\n-- \nAd Min\n");
    }
}

