/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.apache.james.mailbox.elasticsearch.json.EMailer;
import org.apache.james.mailbox.elasticsearch.json.FieldImpl;
import org.apache.james.mailbox.elasticsearch.json.HeaderCollection;
import org.apache.james.mime4j.stream.Field;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class HeaderCollectionTest {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");

    @Test
    public void simpleValueAddressHeaderShouldBeAddedToTheAddressSet() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("To", "btellier@linagora.com")).build();
        Assertions.assertThat((Iterable)headerCollection.getToAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("btellier@linagora.com", "btellier@linagora.com")});
    }

    @Test
    public void comaSeparatedAddressShouldBeBothAddedToTheAddressSet() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("To", "btellier@linagora.com, benwa@minet.net")).build();
        Assertions.assertThat((Iterable)headerCollection.getToAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("btellier@linagora.com", "btellier@linagora.com"), new EMailer("benwa@minet.net", "benwa@minet.net")});
    }

    @Test
    public void addressesOfTwoFieldsHavingTheSameNameShouldBeMerged() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("To", "btellier@linagora.com")).add((Field)new FieldImpl("To", "btellier@linagora.com, benwa@minet.net")).build();
        Assertions.assertThat((Iterable)headerCollection.getToAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("btellier@linagora.com", "btellier@linagora.com"), new EMailer("benwa@minet.net", "benwa@minet.net")});
    }

    @Test
    public void displayNamesShouldBeRetreived() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("To", "Christophe Hamerling <chamerling@linagora.com>")).build();
        Assertions.assertThat((Iterable)headerCollection.getToAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("Christophe Hamerling", "chamerling@linagora.com")});
    }

    @Test
    public void addressWithTwoDisplayNamesOnTheSameFieldShouldBeRetreived() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("From", "Christophe Hamerling <chamerling@linagora.com>, Graham CROSMARIE <gcrosmarie@linagora.com>")).build();
        Assertions.assertThat((Iterable)headerCollection.getFromAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("Christophe Hamerling", "chamerling@linagora.com"), new EMailer("Graham CROSMARIE", "gcrosmarie@linagora.com")});
    }

    @Test
    public void mixingAddressWithDisplayNamesWithOthersShouldBeAllowed() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("To", "Christophe Hamerling <chamerling@linagora.com>, gcrosmarie@linagora.com")).build();
        Assertions.assertThat((Iterable)headerCollection.getToAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("Christophe Hamerling", "chamerling@linagora.com"), new EMailer("gcrosmarie@linagora.com", "gcrosmarie@linagora.com")});
    }

    @Test
    public void displayNamesShouldBeRetreivedOnCc() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Cc", "Christophe Hamerling <chamerling@linagora.com>")).build();
        Assertions.assertThat((Iterable)headerCollection.getCcAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("Christophe Hamerling", "chamerling@linagora.com")});
    }

    @Test
    public void displayNamesShouldBeRetreivedOnReplyTo() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Reply-To", "Christophe Hamerling <chamerling@linagora.com>")).build();
        Assertions.assertThat((Iterable)headerCollection.getReplyToAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("Christophe Hamerling", "chamerling@linagora.com")});
    }

    @Test
    public void displayNamesShouldBeRetreivedOnBcc() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Bcc", "Christophe Hamerling <chamerling@linagora.com>")).build();
        Assertions.assertThat((Iterable)headerCollection.getBccAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("Christophe Hamerling", "chamerling@linagora.com")});
    }

    @Test
    public void headerContaingNoAddressShouldBeConsideredBothAsNameAndAddress() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Bcc", "Not an address")).build();
        Assertions.assertThat((Iterable)headerCollection.getBccAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("Not an address", "Not an address")});
    }

    @Test
    public void unclosedAddressSubpartShouldBeWellHandled() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Bcc", "Mickey <tricky@mouse.com")).build();
        Assertions.assertThat((Iterable)headerCollection.getBccAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("Mickey", "tricky@mouse.com")});
    }

    @Test
    public void notComaSeparatedAddressSubpartShouldBeWellHandled() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Bcc", "Mickey <tricky@mouse.com> Miny<hello@polo.com>")).build();
        Assertions.assertThat((Iterable)headerCollection.getBccAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("Mickey", "tricky@mouse.com"), new EMailer("Miny", "hello@polo.com")});
    }

    @Test
    public void notSeparatedAddressSubpartShouldBeWellHandled1() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Bcc", "Mickey <tricky@mouse.com>Miny<hello@polo.com>")).build();
        Assertions.assertThat((Iterable)headerCollection.getBccAddressSet()).containsOnly((Object[])new EMailer[]{new EMailer("Mickey", "tricky@mouse.com"), new EMailer("Miny", "hello@polo.com")});
    }

    @Test
    public void dateShouldBeRetreived() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Date", "Thu, 4 Jun 2015 06:08:41 +0200")).build();
        Assertions.assertThat((String)DATE_TIME_FORMATTER.format((TemporalAccessor)headerCollection.getSentDate().get())).isEqualTo((Object)"2015/06/04 06:08:41");
    }

    @Test
    public void nonStandardDatesShouldBeRetreived() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Date", "Thu, 4 Jun 2015 06:08:41 +0200 (UTC)")).build();
        Assertions.assertThat((String)DATE_TIME_FORMATTER.format((TemporalAccessor)headerCollection.getSentDate().get())).isEqualTo((Object)"2015/06/04 06:08:41");
    }

    @Test
    public void dateShouldBeAbsentOnInvalidHeader() {
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Date", "Not a date")).build();
        Assertions.assertThat((boolean)headerCollection.getSentDate().isPresent()).isFalse();
    }

    @Test
    public void subjectsShouldBeWellRetrieved() {
        String subject = "A fantastic ElasticSearch module will be available soon for JAMES";
        HeaderCollection headerCollection = HeaderCollection.builder().add((Field)new FieldImpl("Subject", subject)).build();
        Assertions.assertThat((Iterable)headerCollection.getSubjectSet()).containsOnly((Object[])new String[]{"A fantastic ElasticSearch module will be available soon for JAMES"});
    }

    @Test(expected=NullPointerException.class)
    public void nullFieldShouldThrow() {
        HeaderCollection.builder().add(null).build();
    }

    @Test
    public void sanitizeDateStringHeaderValueShouldRemoveCESTPart() {
        Assertions.assertThat((String)HeaderCollection.builder().sanitizeDateStringHeaderValue("Thu, 18 Jun 2015 04:09:35 +0200 (CEST)")).isEqualTo((Object)"Thu, 18 Jun 2015 04:09:35 +0200");
    }

    @Test
    public void sanitizeDateStringHeaderValueShouldRemoveUTCPart() {
        Assertions.assertThat((String)HeaderCollection.builder().sanitizeDateStringHeaderValue("Thu, 18 Jun 2015 04:09:35 +0200  (UTC)  ")).isEqualTo((Object)"Thu, 18 Jun 2015 04:09:35 +0200");
    }

    @Test
    public void sanitizeDateStringHeaderValueShouldNotChangeAcceptableString() {
        Assertions.assertThat((String)HeaderCollection.builder().sanitizeDateStringHeaderValue("Thu, 18 Jun 2015 04:09:35 +0200")).isEqualTo((Object)"Thu, 18 Jun 2015 04:09:35 +0200");
    }

    @Test
    public void sanitizeDateStringHeaderValueShouldNotChangeEmptyString() {
        Assertions.assertThat((String)HeaderCollection.builder().sanitizeDateStringHeaderValue("")).isEqualTo((Object)"");
    }
}

