/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.james.mailbox.elasticsearch.json.EMailer;
import org.apache.james.mailbox.elasticsearch.json.EMailers;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class EMailersTest {
    @Test
    public void fromShouldThrowWhenSetIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> EMailers.from(null)).isInstanceOf(NullPointerException.class)).hasMessage("'emailers' is mandatory");
    }

    @Test
    public void serializeShouldReturnEmptyWhenEmptySet() {
        EMailers eMailers = EMailers.from((Set)ImmutableSet.of());
        Assertions.assertThat((String)eMailers.serialize()).isEmpty();
    }

    @Test
    public void serializeShouldNotJoinWhenOneElement() {
        EMailer emailer = new EMailer("name", "address");
        EMailers eMailers = EMailers.from((Set)ImmutableSet.of((Object)emailer));
        Assertions.assertThat((String)eMailers.serialize()).isEqualTo((Object)emailer.serialize());
    }

    @Test
    public void serializeShouldJoinWhenMultipleElements() {
        EMailer emailer = new EMailer("name", "address");
        EMailer emailer2 = new EMailer("name2", "address2");
        EMailer emailer3 = new EMailer("name3", "address3");
        String expected = Joiner.on((String)" ").join((Object)emailer.serialize(), (Object)emailer2.serialize(), new Object[]{emailer3.serialize()});
        EMailers eMailers = EMailers.from((Set)ImmutableSet.of((Object)emailer, (Object)emailer2, (Object)emailer3));
        Assertions.assertThat((String)eMailers.serialize()).isEqualTo((Object)expected);
    }
}

