/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.elasticsearch.ElasticSearchIndexer;
import org.apache.james.mailbox.elasticsearch.events.ElasticSearchListeningMessageSearchIndex;
import org.apache.james.mailbox.elasticsearch.json.MessageToElasticSearchJson;
import org.apache.james.mailbox.elasticsearch.search.ElasticSearchSearcher;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.TestId;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.junit.Before;
import org.junit.Test;

public class ElasticSearchListeningMailboxMessageSearchIndexTest {
    public static final long MODSEQ = 18L;
    private IMocksControl control;
    private ElasticSearchIndexer indexer;
    private ElasticSearchListeningMessageSearchIndex testee;

    @Before
    public void setup() throws JsonProcessingException {
        this.control = EasyMock.createControl();
        MessageMapperFactory mapperFactory = (MessageMapperFactory)this.control.createMock(MessageMapperFactory.class);
        MessageToElasticSearchJson messageToElasticSearchJson = (MessageToElasticSearchJson)this.control.createMock(MessageToElasticSearchJson.class);
        ElasticSearchSearcher elasticSearchSearcher = (ElasticSearchSearcher)this.control.createMock(ElasticSearchSearcher.class);
        this.indexer = (ElasticSearchIndexer)this.control.createMock(ElasticSearchIndexer.class);
        List users = (List)EasyMock.anyObject();
        EasyMock.expect((Object)messageToElasticSearchJson.convertToJson((MailboxMessage)EasyMock.anyObject(MailboxMessage.class), users)).andReturn((Object)"json content").anyTimes();
        EasyMock.expect((Object)messageToElasticSearchJson.getUpdatedJsonMessagePart((Flags)EasyMock.anyObject(Flags.class), EasyMock.anyLong())).andReturn((Object)"json updated content").anyTimes();
        this.testee = new ElasticSearchListeningMessageSearchIndex(mapperFactory, this.indexer, elasticSearchSearcher, messageToElasticSearchJson);
    }

    @Test
    public void addShouldIndex() throws Exception {
        MailboxSession.User user = (MailboxSession.User)this.control.createMock(MailboxSession.User.class);
        MailboxSession session = (MailboxSession)this.control.createMock(MailboxSession.class);
        EasyMock.expect((Object)session.getUser()).andReturn((Object)user);
        Mailbox mailbox = (Mailbox)this.control.createMock(Mailbox.class);
        MessageUid messageId = MessageUid.of((long)1L);
        TestId mailboxId = TestId.of((long)12L);
        EasyMock.expect((Object)mailbox.getMailboxId()).andReturn((Object)mailboxId);
        MailboxMessage message = this.mockedMessage(messageId);
        IndexResponse expectedIndexResponse = (IndexResponse)this.control.createMock(IndexResponse.class);
        EasyMock.expect((Object)this.indexer.indexMessage((String)EasyMock.eq((Object)(mailboxId.serialize() + ":" + messageId)), EasyMock.anyString())).andReturn((Object)expectedIndexResponse);
        this.control.replay();
        this.testee.add(session, mailbox, message);
        this.control.verify();
    }

    private MailboxMessage mockedMessage(MessageUid messageId) throws IOException {
        MailboxMessage message = (MailboxMessage)this.control.createMock(MailboxMessage.class);
        EasyMock.expect((Object)message.getUid()).andReturn((Object)messageId).anyTimes();
        return message;
    }

    @Test
    public void addShouldNotPropagateExceptionWhenExceptionOccurs() throws Exception {
        MailboxSession.User user = (MailboxSession.User)this.control.createMock(MailboxSession.User.class);
        MailboxSession session = (MailboxSession)this.control.createMock(MailboxSession.class);
        EasyMock.expect((Object)session.getUser()).andReturn((Object)user);
        Mailbox mailbox = (Mailbox)this.control.createMock(Mailbox.class);
        MessageUid messageId = MessageUid.of((long)1L);
        TestId mailboxId = TestId.of((long)12L);
        MailboxMessage message = this.mockedMessage(messageId);
        EasyMock.expect((Object)mailbox.getMailboxId()).andReturn((Object)mailboxId);
        EasyMock.expect((Object)this.indexer.indexMessage((String)EasyMock.eq((Object)(mailboxId.serialize() + ":" + messageId)), EasyMock.anyString())).andThrow((Throwable)new ElasticsearchException("", new Object[0]));
        this.control.replay();
        this.testee.add(session, mailbox, message);
        this.control.verify();
    }

    @Test
    public void deleteShouldWork() throws Exception {
        MailboxSession session = (MailboxSession)this.control.createMock(MailboxSession.class);
        Mailbox mailbox = (Mailbox)this.control.createMock(Mailbox.class);
        MessageUid messageId = MessageUid.of((long)1L);
        TestId mailboxId = TestId.of((long)12L);
        EasyMock.expect((Object)mailbox.getMailboxId()).andReturn((Object)mailboxId);
        BulkResponse expectedBulkResponse = (BulkResponse)this.control.createMock(BulkResponse.class);
        EasyMock.expect((Object)this.indexer.deleteMessages((List)EasyMock.anyObject(List.class))).andReturn((Object)expectedBulkResponse);
        this.control.replay();
        this.testee.delete(session, mailbox, (List)Lists.newArrayList((Object[])new MessageUid[]{messageId}));
        this.control.verify();
    }

    @Test
    public void deleteShouldWorkWhenMultipleMessageIds() throws Exception {
        MailboxSession session = (MailboxSession)this.control.createMock(MailboxSession.class);
        Mailbox mailbox = (Mailbox)this.control.createMock(Mailbox.class);
        MessageUid messageId1 = MessageUid.of((long)1L);
        MessageUid messageId2 = MessageUid.of((long)2L);
        MessageUid messageId3 = MessageUid.of((long)3L);
        MessageUid messageId4 = MessageUid.of((long)4L);
        MessageUid messageId5 = MessageUid.of((long)5L);
        TestId mailboxId = TestId.of((long)12L);
        EasyMock.expect((Object)mailbox.getMailboxId()).andReturn((Object)mailboxId).times(5);
        BulkResponse expectedBulkResponse = (BulkResponse)this.control.createMock(BulkResponse.class);
        EasyMock.expect((Object)this.indexer.deleteMessages((List)EasyMock.anyObject(List.class))).andReturn((Object)expectedBulkResponse);
        this.control.replay();
        this.testee.delete(session, mailbox, (List)Lists.newArrayList((Object[])new MessageUid[]{messageId1, messageId2, messageId3, messageId4, messageId5}));
        this.control.verify();
    }

    @Test
    public void deleteShouldNotPropagateExceptionWhenExceptionOccurs() throws Exception {
        MailboxSession session = (MailboxSession)this.control.createMock(MailboxSession.class);
        Mailbox mailbox = (Mailbox)this.control.createMock(Mailbox.class);
        MessageUid messageId = MessageUid.of((long)1L);
        TestId mailboxId = TestId.of((long)12L);
        EasyMock.expect((Object)mailbox.getMailboxId()).andReturn((Object)mailboxId).times(2);
        EasyMock.expect((Object)this.indexer.deleteMessages((List)EasyMock.anyObject(List.class))).andThrow((Throwable)new ElasticsearchException("", new Object[0]));
        this.control.replay();
        this.testee.delete(session, mailbox, (List)Lists.newArrayList((Object[])new MessageUid[]{messageId}));
        this.control.verify();
    }

    @Test
    public void updateShouldWork() throws Exception {
        MailboxSession session = (MailboxSession)this.control.createMock(MailboxSession.class);
        Mailbox mailbox = (Mailbox)this.control.createMock(Mailbox.class);
        Flags flags = new Flags();
        MessageUid messageId = MessageUid.of((long)1L);
        UpdatedFlags updatedFlags = new UpdatedFlags(messageId, 18L, flags, flags);
        TestId mailboxId = TestId.of((long)12L);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)mailbox.getMailboxId()).andReturn((Object)mailboxId);
        BulkResponse expectedBulkResponse = (BulkResponse)this.control.createMock(BulkResponse.class);
        EasyMock.expect((Object)this.indexer.updateMessages((List)EasyMock.anyObject(List.class))).andReturn((Object)expectedBulkResponse);
        this.control.replay();
        this.testee.update(session, mailbox, (List)Lists.newArrayList((Object[])new UpdatedFlags[]{updatedFlags}));
        this.control.verify();
    }

    @Test
    public void updateShouldNotPropagateExceptionWhenExceptionOccurs() throws Exception {
        MailboxSession session = (MailboxSession)this.control.createMock(MailboxSession.class);
        Mailbox mailbox = (Mailbox)this.control.createMock(Mailbox.class);
        Flags flags = new Flags();
        MessageUid messageId = MessageUid.of((long)1L);
        UpdatedFlags updatedFlags = new UpdatedFlags(messageId, 18L, flags, flags);
        TestId mailboxId = TestId.of((long)12L);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)mailbox.getMailboxId()).andReturn((Object)mailboxId).times(2);
        EasyMock.expect((Object)this.indexer.updateMessages((List)EasyMock.anyObject(List.class))).andThrow((Throwable)new ElasticsearchException("", new Object[0]));
        this.control.replay();
        this.testee.update(session, mailbox, (List)Lists.newArrayList((Object[])new UpdatedFlags[]{updatedFlags}));
        this.control.verify();
    }

    @Test
    public void deleteAllShouldWork() throws Exception {
        MailboxSession session = (MailboxSession)this.control.createMock(MailboxSession.class);
        Mailbox mailbox = (Mailbox)this.control.createMock(Mailbox.class);
        TestId mailboxId = TestId.of((long)12L);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)mailbox.getMailboxId()).andReturn((Object)mailboxId);
        this.indexer.deleteAllMatchingQuery((QueryBuilder)EasyMock.anyObject(QueryBuilder.class));
        EasyMock.expectLastCall();
        this.control.replay();
        this.testee.deleteAll(session, mailbox);
        this.control.verify();
    }

    @Test
    public void deleteAllShouldNotPropagateExceptionWhenExceptionOccurs() throws Exception {
        MailboxSession session = (MailboxSession)this.control.createMock(MailboxSession.class);
        Mailbox mailbox = (Mailbox)this.control.createMock(Mailbox.class);
        TestId mailboxId = TestId.of((long)12L);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)mailbox.getMailboxId()).andReturn((Object)mailboxId).times(2);
        this.indexer.deleteAllMatchingQuery((QueryBuilder)EasyMock.anyObject(QueryBuilder.class));
        EasyMock.expectLastCall().andThrow((Throwable)new ElasticsearchException("", new Object[0]));
        this.control.replay();
        this.testee.deleteAll(session, mailbox);
        this.control.verify();
    }
}

