/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch;

import com.google.common.base.Throwables;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushAction;
import org.elasticsearch.action.admin.indices.flush.FlushRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedElasticSearch
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedElasticSearch.class);
    private final Supplier<Path> folder;
    private Node node;

    private static Path createTempDir(TemporaryFolder temporaryFolder) {
        try {
            return temporaryFolder.newFolder().toPath();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public EmbeddedElasticSearch(TemporaryFolder temporaryFolder) {
        this(() -> EmbeddedElasticSearch.createTempDir(temporaryFolder));
    }

    public EmbeddedElasticSearch(Path folder) {
        this(() -> folder);
    }

    private EmbeddedElasticSearch(Supplier<Path> folder) {
        this.folder = folder;
    }

    public void before() throws IOException {
        this.node = NodeBuilder.nodeBuilder().local(true).settings(Settings.builder().put(new Object[]{"path.home", this.folder.get().toAbsolutePath()}).build()).node();
        this.node.start();
        this.awaitForElasticSearch();
    }

    public void after() {
        this.awaitForElasticSearch();
        try (Client client = this.node.client();){
            client.admin().indices().delete(new DeleteIndexRequest("mailbox")).actionGet();
        }
        catch (Exception e) {
            LOGGER.warn("Error while closing ES connection", (Throwable)e);
        }
        this.node.close();
    }

    public Node getNode() {
        return this.node;
    }

    public void awaitForElasticSearch() {
        Awaitility.await().atMost(Duration.TEN_SECONDS).until(this::flush);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean flush() {
        try (Client client = this.node.client();){
            new FlushRequestBuilder((ElasticsearchClient)client, FlushAction.INSTANCE).setForce(true).get();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }
}

