/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch;

import java.time.ZoneId;
import java.util.concurrent.Executors;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.elasticsearch.DeleteByQueryPerformer;
import org.apache.james.mailbox.elasticsearch.ElasticSearchIndexer;
import org.apache.james.mailbox.elasticsearch.EmbeddedElasticSearch;
import org.apache.james.mailbox.elasticsearch.IndexCreationFactory;
import org.apache.james.mailbox.elasticsearch.NodeMappingFactory;
import org.apache.james.mailbox.elasticsearch.events.ElasticSearchListeningMessageSearchIndex;
import org.apache.james.mailbox.elasticsearch.json.MessageToElasticSearchJson;
import org.apache.james.mailbox.elasticsearch.query.CriterionConverter;
import org.apache.james.mailbox.elasticsearch.query.QueryConverter;
import org.apache.james.mailbox.elasticsearch.search.ElasticSearchSearcher;
import org.apache.james.mailbox.elasticsearch.utils.TestingClientProvider;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.FakeAuthenticator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.search.AbstractMessageSearchIndexTest;
import org.elasticsearch.client.Client;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class ElasticSearchIntegrationTest
extends AbstractMessageSearchIndexTest {
    private static final int BATCH_SIZE = 1;
    private static final int SEARCH_SIZE = 1;
    private TemporaryFolder temporaryFolder = new TemporaryFolder();
    private EmbeddedElasticSearch embeddedElasticSearch = new EmbeddedElasticSearch(this.temporaryFolder);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.temporaryFolder).around((TestRule)this.embeddedElasticSearch);

    protected void await() {
        this.embeddedElasticSearch.awaitForElasticSearch();
    }

    protected void initializeMailboxManager() throws Exception {
        Client client = NodeMappingFactory.applyMapping((Client)IndexCreationFactory.createIndex((Client)new TestingClientProvider(this.embeddedElasticSearch.getNode()).get()));
        InMemoryMailboxSessionMapperFactory mapperFactory = new InMemoryMailboxSessionMapperFactory();
        this.messageSearchIndex = new ElasticSearchListeningMessageSearchIndex((MessageMapperFactory)mapperFactory, new ElasticSearchIndexer(client, new DeleteByQueryPerformer(client, Executors.newSingleThreadExecutor(), 1)), new ElasticSearchSearcher(client, new QueryConverter(new CriterionConverter()), 1, (MailboxId.Factory)new InMemoryId.Factory()), new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.of("Europe/Paris")));
        DefaultMessageId.Factory messageIdFactory = new DefaultMessageId.Factory();
        this.storeMailboxManager = new InMemoryMailboxManager((MailboxSessionMapperFactory)mapperFactory, (Authenticator)new FakeAuthenticator(), (MailboxPathLocker)new JVMMailboxPathLocker(), (MailboxACLResolver)new UnionMailboxACLResolver(), (GroupMembershipResolver)new SimpleGroupMembershipResolver(), new MessageParser(), (MessageId.Factory)messageIdFactory);
        this.storeMailboxManager.setMessageSearchIndex(this.messageSearchIndex);
        this.storeMailboxManager.init();
    }
}

