/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import org.apache.james.mailbox.elasticsearch.DeleteByQueryPerformer;
import org.apache.james.mailbox.elasticsearch.ElasticSearchIndexer;
import org.apache.james.mailbox.elasticsearch.EmbeddedElasticSearch;
import org.apache.james.mailbox.elasticsearch.utils.TestingClientProvider;
import org.assertj.core.api.Assertions;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class ElasticSearchIndexerTest {
    private static final int MINIMUM_BATCH_SIZE = 1;
    private TemporaryFolder temporaryFolder = new TemporaryFolder();
    private EmbeddedElasticSearch embeddedElasticSearch = new EmbeddedElasticSearch(this.temporaryFolder);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.temporaryFolder).around((TestRule)this.embeddedElasticSearch);
    private Node node;
    private ElasticSearchIndexer testee;

    @Before
    public void setup() throws IOException {
        this.node = this.embeddedElasticSearch.getNode();
        TestingClientProvider clientProvider = new TestingClientProvider(this.node);
        DeleteByQueryPerformer deleteByQueryPerformer = new DeleteByQueryPerformer(clientProvider.get(), Executors.newSingleThreadExecutor(), 1){

            public void perform(QueryBuilder queryBuilder) {
                this.doDeleteByQuery(queryBuilder);
            }
        };
        this.testee = new ElasticSearchIndexer(clientProvider.get(), deleteByQueryPerformer);
    }

    @Test
    public void indexMessageShouldWork() throws Exception {
        String messageId = "1";
        String content = "{\"message\": \"trying out Elasticsearch\"}";
        this.testee.indexMessage(messageId, content);
        this.embeddedElasticSearch.awaitForElasticSearch();
        try (Client client = this.node.client();){
            SearchResponse searchResponse = (SearchResponse)client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{"message"}).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"message", (Object)"trying")).get();
            Assertions.assertThat((long)searchResponse.getHits().getTotalHits()).isEqualTo(1L);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void indexMessageShouldThrowWhenJsonIsNull() throws InterruptedException {
        this.testee.indexMessage("1", null);
    }

    @Test
    public void updateMessages() throws Exception {
        SearchResponse searchResponse;
        String messageId = "1";
        String content = "{\"message\": \"trying out Elasticsearch\",\"field\":\"Should be unchanged\"}";
        this.testee.indexMessage(messageId, content);
        this.embeddedElasticSearch.awaitForElasticSearch();
        this.testee.updateMessages((List)Lists.newArrayList((Object[])new ElasticSearchIndexer.UpdatedRepresentation[]{new ElasticSearchIndexer.UpdatedRepresentation(messageId, "{\"message\": \"mastering out Elasticsearch\"}")}));
        this.embeddedElasticSearch.awaitForElasticSearch();
        try (Client client = this.node.client();){
            searchResponse = (SearchResponse)client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{"message"}).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"message", (Object)"mastering")).get();
            Assertions.assertThat((long)searchResponse.getHits().getTotalHits()).isEqualTo(1L);
        }
        client = this.node.client();
        var4_4 = null;
        try {
            searchResponse = (SearchResponse)client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{"message"}).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"field", (Object)"unchanged")).get();
            Assertions.assertThat((long)searchResponse.getHits().getTotalHits()).isEqualTo(1L);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var4_4 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateMessageShouldThrowWhenJsonIsNull() throws InterruptedException {
        this.testee.updateMessages((List)Lists.newArrayList((Object[])new ElasticSearchIndexer.UpdatedRepresentation[]{new ElasticSearchIndexer.UpdatedRepresentation("1", null)}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateMessageShouldThrowWhenIdIsNull() throws InterruptedException {
        this.testee.updateMessages((List)Lists.newArrayList((Object[])new ElasticSearchIndexer.UpdatedRepresentation[]{new ElasticSearchIndexer.UpdatedRepresentation(null, "{\"message\": \"mastering out Elasticsearch\"}")}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateMessageShouldThrowWhenJsonIsEmpty() throws InterruptedException {
        this.testee.updateMessages((List)Lists.newArrayList((Object[])new ElasticSearchIndexer.UpdatedRepresentation[]{new ElasticSearchIndexer.UpdatedRepresentation("1", "")}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateMessageShouldThrowWhenIdIsEmpty() throws InterruptedException {
        this.testee.updateMessages((List)Lists.newArrayList((Object[])new ElasticSearchIndexer.UpdatedRepresentation[]{new ElasticSearchIndexer.UpdatedRepresentation("", "{\"message\": \"mastering out Elasticsearch\"}")}));
    }

    @Test
    public void deleteByQueryShouldWorkOnSingleMessage() throws Exception {
        String messageId = "1:2";
        String content = "{\"message\": \"trying out Elasticsearch\", \"mailboxId\":\"1\"}";
        this.testee.indexMessage(messageId, content);
        this.embeddedElasticSearch.awaitForElasticSearch();
        this.testee.deleteAllMatchingQuery((QueryBuilder)QueryBuilders.termQuery((String)"mailboxId", (String)"1"));
        this.embeddedElasticSearch.awaitForElasticSearch();
        try (Client client = this.node.client();){
            SearchResponse searchResponse = (SearchResponse)client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{"message"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
            Assertions.assertThat((long)searchResponse.getHits().getTotalHits()).isEqualTo(0L);
        }
    }

    @Test
    public void deleteByQueryShouldWorkWhenMultipleMessages() throws Exception {
        String messageId = "1:1";
        String content = "{\"message\": \"trying out Elasticsearch\", \"mailboxId\":\"1\"}";
        this.testee.indexMessage(messageId, content);
        String messageId2 = "1:2";
        String content2 = "{\"message\": \"trying out Elasticsearch 2\", \"mailboxId\":\"1\"}";
        this.testee.indexMessage(messageId2, content2);
        String messageId3 = "2:3";
        String content3 = "{\"message\": \"trying out Elasticsearch 3\", \"mailboxId\":\"2\"}";
        this.testee.indexMessage(messageId3, content3);
        this.embeddedElasticSearch.awaitForElasticSearch();
        this.testee.deleteAllMatchingQuery((QueryBuilder)QueryBuilders.termQuery((String)"mailboxId", (String)"1"));
        this.embeddedElasticSearch.awaitForElasticSearch();
        try (Client client = this.node.client();){
            SearchResponse searchResponse = (SearchResponse)client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{"message"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
            Assertions.assertThat((long)searchResponse.getHits().getTotalHits()).isEqualTo(1L);
        }
    }

    @Test
    public void deleteMessage() throws Exception {
        String messageId = "1:2";
        String content = "{\"message\": \"trying out Elasticsearch\"}";
        this.testee.indexMessage(messageId, content);
        this.embeddedElasticSearch.awaitForElasticSearch();
        this.testee.deleteMessages((List)Lists.newArrayList((Object[])new String[]{messageId}));
        this.embeddedElasticSearch.awaitForElasticSearch();
        try (Client client = this.node.client();){
            SearchResponse searchResponse = (SearchResponse)client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{"message"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
            Assertions.assertThat((long)searchResponse.getHits().getTotalHits()).isEqualTo(0L);
        }
    }

    @Test
    public void deleteShouldWorkWhenMultipleMessages() throws Exception {
        String messageId = "1:1";
        String content = "{\"message\": \"trying out Elasticsearch\", \"mailboxId\":\"1\"}";
        this.testee.indexMessage(messageId, content);
        String messageId2 = "1:2";
        String content2 = "{\"message\": \"trying out Elasticsearch 2\", \"mailboxId\":\"1\"}";
        this.testee.indexMessage(messageId2, content2);
        String messageId3 = "2:3";
        String content3 = "{\"message\": \"trying out Elasticsearch 3\", \"mailboxId\":\"2\"}";
        this.testee.indexMessage(messageId3, content3);
        this.embeddedElasticSearch.awaitForElasticSearch();
        this.testee.deleteMessages((List)Lists.newArrayList((Object[])new String[]{messageId, messageId3}));
        this.embeddedElasticSearch.awaitForElasticSearch();
        try (Client client = this.node.client();){
            SearchResponse searchResponse = (SearchResponse)client.prepareSearch(new String[]{"mailbox"}).setTypes(new String[]{"message"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
            Assertions.assertThat((long)searchResponse.getHits().getTotalHits()).isEqualTo(1L);
        }
    }
}

