/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.blob.api.BucketName;
import org.apache.james.vault.DeletedMessageFixture;
import org.apache.james.vault.metadata.DeletedMessageMetadataVault;
import org.apache.james.vault.metadata.DeletedMessageVaultMetadataFixture;
import org.apache.james.vault.metadata.DeletedMessageWithStorageInformation;
import org.apache.james.vault.metadata.StorageInformation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DeletedMessageMetadataVaultContract {
    public DeletedMessageMetadataVault metadataVault();

    @Test
    default public void listMessagesShouldBeEmptyWhenNoMessageInserted() {
        Stream messages = Flux.from((Publisher)this.metadataVault().listMessages(DeletedMessageVaultMetadataFixture.BUCKET_NAME, DeletedMessageFixture.USERNAME)).toStream();
        Assertions.assertThat((Stream)messages).isEmpty();
    }

    @Test
    default public void listMessagesShouldContainPreviouslyInsertedMessage() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        Stream messages = Flux.from((Publisher)this.metadataVault().listMessages(DeletedMessageVaultMetadataFixture.BUCKET_NAME, DeletedMessageFixture.USERNAME)).toStream();
        Assertions.assertThat((Stream)messages).containsOnly((Object[])new DeletedMessageWithStorageInformation[]{DeletedMessageVaultMetadataFixture.DELETED_MESSAGE});
    }

    @Test
    default public void listMessagesShouldContainAllPreviouslyInsertedMessages() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2)).block();
        Stream messages = Flux.from((Publisher)this.metadataVault().listMessages(DeletedMessageVaultMetadataFixture.BUCKET_NAME, DeletedMessageFixture.USERNAME)).toStream();
        Assertions.assertThat((Stream)messages).containsOnly((Object[])new DeletedMessageWithStorageInformation[]{DeletedMessageVaultMetadataFixture.DELETED_MESSAGE, DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2});
    }

    @Test
    default public void listMessagesShouldNotReturnMessagesOfOtherBuckets() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2_OTHER_BUCKET)).block();
        Stream messages = Flux.from((Publisher)this.metadataVault().listMessages(DeletedMessageVaultMetadataFixture.BUCKET_NAME, DeletedMessageFixture.USERNAME)).toStream();
        Assertions.assertThat((Stream)messages).containsOnly((Object[])new DeletedMessageWithStorageInformation[]{DeletedMessageVaultMetadataFixture.DELETED_MESSAGE});
    }

    @Test
    default public void listBucketsShouldBeEmptyWhenNoMessageInserted() {
        Stream messages = Flux.from((Publisher)this.metadataVault().listRelatedBuckets()).toStream();
        Assertions.assertThat((Stream)messages).isEmpty();
    }

    @Test
    default public void listBucketsShouldReturnAllUsedBuckets() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2_OTHER_BUCKET)).block();
        Stream messages = Flux.from((Publisher)this.metadataVault().listRelatedBuckets()).toStream();
        Assertions.assertThat((Stream)messages).containsOnly((Object[])new BucketName[]{DeletedMessageVaultMetadataFixture.BUCKET_NAME, DeletedMessageVaultMetadataFixture.OTHER_BUCKET_NAME});
    }

    @Test
    default public void listBucketsShouldNotReturnDuplicates() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2)).block();
        Stream messages = Flux.from((Publisher)this.metadataVault().listRelatedBuckets()).toStream();
        Assertions.assertThat((Stream)messages).containsExactly((Object[])new BucketName[]{DeletedMessageVaultMetadataFixture.BUCKET_NAME});
    }

    @Test
    default public void listBucketsShouldStillListNotYetDeletedBuckets() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2_OTHER_BUCKET)).block();
        Mono.from((Publisher)this.metadataVault().removeMetadataRelatedToBucket(DeletedMessageVaultMetadataFixture.BUCKET_NAME)).block();
        Stream messages = Flux.from((Publisher)this.metadataVault().listRelatedBuckets()).toStream();
        Assertions.assertThat((Stream)messages).containsOnly((Object[])new BucketName[]{DeletedMessageVaultMetadataFixture.OTHER_BUCKET_NAME});
    }

    @Test
    default public void listBucketsShouldNotReturnDeletedBuckets() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2)).block();
        Mono.from((Publisher)this.metadataVault().removeMetadataRelatedToBucket(DeletedMessageVaultMetadataFixture.BUCKET_NAME)).block();
        Stream messages = Flux.from((Publisher)this.metadataVault().listRelatedBuckets()).toStream();
        Assertions.assertThat((Stream)messages).isEmpty();
    }

    @Test
    default public void removeBucketShouldOnlyRemoveEntriesOfTheGivenBucket() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2_OTHER_BUCKET)).block();
        Mono.from((Publisher)this.metadataVault().removeMetadataRelatedToBucket(DeletedMessageVaultMetadataFixture.BUCKET_NAME)).block();
        Stream messages = Flux.from((Publisher)this.metadataVault().listMessages(DeletedMessageVaultMetadataFixture.OTHER_BUCKET_NAME, DeletedMessageFixture.USERNAME)).toStream();
        Assertions.assertThat((Stream)messages).containsOnly((Object[])new DeletedMessageWithStorageInformation[]{DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2_OTHER_BUCKET});
    }

    @Test
    default public void removeBucketShouldRemoveAllEntriesOfTheGivenBucket() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2)).block();
        Mono.from((Publisher)this.metadataVault().removeMetadataRelatedToBucket(DeletedMessageVaultMetadataFixture.BUCKET_NAME)).block();
        Stream messages = Flux.from((Publisher)this.metadataVault().listMessages(DeletedMessageVaultMetadataFixture.BUCKET_NAME, DeletedMessageFixture.USERNAME)).toStream();
        Assertions.assertThat((Stream)messages).isEmpty();
    }

    @Test
    default public void listMessagesShouldNotReturnRemovedItems() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2)).block();
        Mono.from((Publisher)this.metadataVault().remove(DeletedMessageVaultMetadataFixture.BUCKET_NAME, DeletedMessageFixture.USERNAME, DeletedMessageVaultMetadataFixture.DELETED_MESSAGE.getDeletedMessage().getMessageId())).block();
        Stream messages = Flux.from((Publisher)this.metadataVault().listMessages(DeletedMessageVaultMetadataFixture.BUCKET_NAME, DeletedMessageFixture.USERNAME)).toStream();
        Assertions.assertThat((Stream)messages).containsExactly((Object[])new DeletedMessageWithStorageInformation[]{DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2});
    }

    @Test
    default public void removeShouldNotFailWhenTheMessageDoesNotExist() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2)).block();
        Assertions.assertThatCode(() -> Mono.from((Publisher)this.metadataVault().remove(DeletedMessageVaultMetadataFixture.BUCKET_NAME, DeletedMessageFixture.USERNAME, DeletedMessageVaultMetadataFixture.DELETED_MESSAGE.getDeletedMessage().getMessageId())).block()).doesNotThrowAnyException();
    }

    @Test
    default public void retrieveStorageInformationShouldReturnStoredValue() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE)).block();
        StorageInformation storageInformation = (StorageInformation)Mono.from((Publisher)this.metadataVault().retrieveStorageInformation(DeletedMessageFixture.USERNAME, DeletedMessageVaultMetadataFixture.DELETED_MESSAGE.getDeletedMessage().getMessageId())).block();
        Assertions.assertThat((Object)storageInformation).isEqualTo((Object)DeletedMessageVaultMetadataFixture.DELETED_MESSAGE.getStorageInformation());
    }

    @Test
    default public void retrieveStorageInformationShouldReturnEmptyWhenNotStored() {
        Mono.from((Publisher)this.metadataVault().store(DeletedMessageVaultMetadataFixture.DELETED_MESSAGE_2)).block();
        Optional storageInformation = Mono.from((Publisher)this.metadataVault().retrieveStorageInformation(DeletedMessageFixture.USERNAME, DeletedMessageVaultMetadataFixture.DELETED_MESSAGE.getDeletedMessage().getMessageId())).blockOptional();
        Assertions.assertThat((Optional)storageInformation).isEmpty();
    }

    @Test
    default public void retrieveStorageInformationShouldReturnEmptyWhenUserVaultIsEmpty() {
        Optional storageInformation = Mono.from((Publisher)this.metadataVault().retrieveStorageInformation(DeletedMessageFixture.USERNAME, DeletedMessageVaultMetadataFixture.DELETED_MESSAGE.getDeletedMessage().getMessageId())).blockOptional();
        Assertions.assertThat((Optional)storageInformation).isEmpty();
    }
}

