/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto.query;

import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.vault.dto.query.CriterionDTO;
import org.apache.james.vault.dto.query.QueryDTO;
import org.apache.james.vault.dto.query.QueryElement;
import org.apache.james.vault.dto.query.QueryTranslator;
import org.apache.james.vault.search.Criterion;
import org.apache.james.vault.search.CriterionFactory;
import org.apache.james.vault.search.FieldName;
import org.apache.james.vault.search.Operator;
import org.apache.james.vault.search.Query;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class QueryTranslatorTest {
    private QueryTranslator queryTranslator;

    QueryTranslatorTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.queryTranslator = new QueryTranslator((MailboxId.Factory)new InMemoryId.Factory());
    }

    @Test
    void translateShouldThrowWhenPassingNotAndOperator() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.queryTranslator.translate(new QueryDTO("or", (List)ImmutableList.of()))).isInstanceOf(IllegalArgumentException.class)).hasMessage("combinator 'or' is not yet handled");
    }

    @Test
    void translateShouldNotThrowWhenPassingNullOperator() {
        String nullOperator = null;
        Assertions.assertThatCode(() -> this.queryTranslator.translate(new QueryDTO(nullOperator, (List)ImmutableList.of()))).doesNotThrowAnyException();
    }

    @Test
    void translateShouldThrowWhenPassingNestedQuery() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.queryTranslator.translate(QueryDTO.and((QueryElement[])new QueryElement[]{QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.SUBJECT.getValue(), Operator.CONTAINS.getValue(), "james")})}))).isInstanceOf(IllegalArgumentException.class)).hasMessage("nested query structure is not yet handled");
    }

    @Test
    void translateShouldNotThrowWhenPassingFlattenQuery() {
        Assertions.assertThatCode(() -> this.queryTranslator.translate(QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.SUBJECT.getValue(), Operator.CONTAINS.getValue(), "james"), new CriterionDTO(FieldName.SENDER.getValue(), Operator.EQUALS.getValue(), "user@james.org"), new CriterionDTO(FieldName.HAS_ATTACHMENT.getValue(), Operator.EQUALS.getValue(), "true")}))).doesNotThrowAnyException();
    }

    @Test
    void toDTOShouldConvertQueryWithDeletionDateBeforeOrEquals() throws Exception {
        String serializedDate = "2007-12-03T10:15:30+01:00[Europe/Paris]";
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.deletionDate().beforeOrEquals(ZonedDateTime.parse(serializedDate))});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.DELETION_DATE.getValue(), Operator.BEFORE_OR_EQUALS.getValue(), serializedDate)}));
    }

    @Test
    void toDTOShouldConvertQueryWithDeletionDateAfterOrEquals() throws Exception {
        String serializedDate = "2007-12-03T10:15:30+01:00[Europe/Paris]";
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.deletionDate().afterOrEquals(ZonedDateTime.parse(serializedDate))});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.DELETION_DATE.getValue(), Operator.AFTER_OR_EQUALS.getValue(), serializedDate)}));
    }

    @Test
    void toDTOShouldConvertQueryWithDeliveryDateBeforeOrEquals() throws Exception {
        String serializedDate = "2007-12-03T10:15:30+01:00[Europe/Paris]";
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.deliveryDate().beforeOrEquals(ZonedDateTime.parse(serializedDate))});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.DELIVERY_DATE.getValue(), Operator.BEFORE_OR_EQUALS.getValue(), serializedDate)}));
    }

    @Test
    void toDTOShouldConvertQueryWithDeliveryDateAfterOrEquals() throws Exception {
        String serializedDate = "2007-12-03T10:15:30+01:00[Europe/Paris]";
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.deliveryDate().afterOrEquals(ZonedDateTime.parse(serializedDate))});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.DELIVERY_DATE.getValue(), Operator.AFTER_OR_EQUALS.getValue(), serializedDate)}));
    }

    @Test
    void toDTOShouldConvertQueryWithRecipientsContains() throws Exception {
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.containsRecipient((MailAddress)new MailAddress("user@james.org"))});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.RECIPIENTS.getValue(), Operator.CONTAINS.getValue(), "user@james.org")}));
    }

    @Test
    void toDTOShouldConvertQueryWithSenderEquals() throws Exception {
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.hasSender((MailAddress)new MailAddress("user@james.org"))});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.SENDER.getValue(), Operator.EQUALS.getValue(), "user@james.org")}));
    }

    @Test
    void toDTOShouldConvertQueryWithHasAttachement() {
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.hasAttachment((boolean)true)});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.HAS_ATTACHMENT.getValue(), Operator.EQUALS.getValue(), "true")}));
    }

    @Test
    void toDTOShouldConvertQueryWithSubjectEquals() {
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equals("james")});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.SUBJECT.getValue(), Operator.EQUALS.getValue(), "james")}));
    }

    @Test
    void toDTOShouldConvertQueryWithSubjectEqualsIgnoreCase() {
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equalsIgnoreCase("james")});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.SUBJECT.getValue(), Operator.EQUALS_IGNORE_CASE.getValue(), "james")}));
    }

    @Test
    void toDTOShouldConvertQueryWithSubjectContains() {
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().contains("james")});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.SUBJECT.getValue(), Operator.CONTAINS.getValue(), "james")}));
    }

    @Test
    void toDTOShouldConvertQueryWithSubjectContainsIgnoreCase() {
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().containsIgnoreCase("james")});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.SUBJECT.getValue(), Operator.CONTAINS_IGNORE_CASE.getValue(), "james")}));
    }

    @Test
    void toDTOShouldConvertQueryWithContainsOriginMailbox() {
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.containsOriginMailbox((MailboxId)TestId.of((long)1L))});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.ORIGIN_MAILBOXES.getValue(), Operator.CONTAINS.getValue(), "1")}));
    }

    @Test
    void toDTOShouldConvertFlattenQuery() throws Exception {
        Query query = Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().contains("james"), CriterionFactory.hasSender((MailAddress)new MailAddress("user@james.org")), CriterionFactory.hasAttachment((boolean)true)});
        Assertions.assertThat((Object)this.queryTranslator.toDTO(query)).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{new CriterionDTO(FieldName.SUBJECT.getValue(), Operator.CONTAINS.getValue(), "james"), new CriterionDTO(FieldName.SENDER.getValue(), Operator.EQUALS.getValue(), "user@james.org"), new CriterionDTO(FieldName.HAS_ATTACHMENT.getValue(), Operator.EQUALS.getValue(), "true")}));
    }
}

