/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.vault.dto.query.CriterionDTO;
import org.apache.james.vault.dto.query.QueryDTO;
import org.apache.james.vault.dto.query.QueryElement;
import org.apache.james.vault.dto.query.QueryElementSerializer;
import org.apache.james.vault.search.FieldName;
import org.apache.james.vault.search.Operator;
import org.apache.mailet.base.MailAddressFixture;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class QueryElementSerializerTest {
    private QueryElementSerializer queryElementSerializer;

    QueryElementSerializerTest() {
    }

    @BeforeEach
    void beforeEach() {
        ObjectMapper objectMapper = new ObjectMapper();
        this.queryElementSerializer = new QueryElementSerializer(objectMapper);
    }

    @Test
    void shouldSerializeNestedStructure() throws Exception {
        QueryDTO queryDTO = QueryDTO.and((QueryElement[])new QueryElement[]{QueryDTO.and((QueryElement[])new QueryElement[]{CriterionDTO.from((FieldName)FieldName.SUBJECT, (Operator)Operator.CONTAINS, (String)"subject"), CriterionDTO.from((FieldName)FieldName.SENDER, (Operator)Operator.EQUALS, (String)MailAddressFixture.SENDER.asString())}), CriterionDTO.from((FieldName)FieldName.HAS_ATTACHMENT, (Operator)Operator.EQUALS, (String)"true")});
        JsonAssertions.assertThatJson((Object)this.queryElementSerializer.serialize((QueryElement)queryDTO)).isEqualTo((Object)("{    \"combinator\": \"and\",    \"criteria\": [      {        \"combinator\": \"and\",        \"criteria\": [          {\"fieldName\": \"subject\", \"operator\": \"contains\", \"value\": \"subject\"},        {\"fieldName\": \"sender\", \"operator\": \"equals\", \"value\": \"" + MailAddressFixture.SENDER.asString() + "\"}      ]      },      {\"fieldName\": \"hasAttachment\", \"operator\": \"equals\", \"value\": \"true\"}  ]  }  "));
    }

    @Test
    void shouldSerializeFlattenStructure() throws Exception {
        QueryDTO queryDTO = QueryDTO.and((QueryElement[])new QueryElement[]{CriterionDTO.from((FieldName)FieldName.SUBJECT, (Operator)Operator.CONTAINS, (String)"subject"), CriterionDTO.from((FieldName)FieldName.SENDER, (Operator)Operator.EQUALS, (String)MailAddressFixture.SENDER.asString()), CriterionDTO.from((FieldName)FieldName.HAS_ATTACHMENT, (Operator)Operator.EQUALS, (String)"true")});
        JsonAssertions.assertThatJson((Object)this.queryElementSerializer.serialize((QueryElement)queryDTO)).isEqualTo((Object)("{    \"combinator\": \"and\",    \"criteria\": [      {\"fieldName\": \"subject\", \"operator\": \"contains\", \"value\": \"subject\"},    {\"fieldName\": \"sender\", \"operator\": \"equals\", \"value\": \"" + MailAddressFixture.SENDER.asString() + "\"},    {\"fieldName\": \"hasAttachment\", \"operator\": \"equals\", \"value\": \"true\"}  ]  }  "));
    }
}

