/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.james.vault.dto.query.CriterionDTO;
import org.apache.james.vault.dto.query.QueryDTO;
import org.apache.james.vault.dto.query.QueryElement;
import org.apache.james.vault.search.FieldName;
import org.apache.james.vault.search.Operator;
import org.apache.mailet.base.MailAddressFixture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class QueryElementDeserializerTest {
    private ObjectMapper objectMapper;

    QueryElementDeserializerTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.objectMapper = new ObjectMapper();
    }

    @Test
    void shouldDeserializeNestedStructure() throws Exception {
        String queryJson = "{    \"combinator\": \"and\",    \"criteria\": [      {        \"combinator\": \"and\",        \"criteria\": [          {\"fieldName\": \"subject\", \"operator\": \"contains\", \"value\": \"subject\"},        {\"fieldName\": \"sender\", \"operator\": \"equals\", \"value\": \"" + MailAddressFixture.SENDER.asString() + "\"}      ]      },      {\"fieldName\": \"hasAttachment\", \"operator\": \"equals\", \"value\": \"true\"}  ]  }  ";
        QueryDTO queryDTO = (QueryDTO)this.objectMapper.readValue(queryJson, QueryDTO.class);
        Assertions.assertThat((Object)queryDTO).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{QueryDTO.and((QueryElement[])new QueryElement[]{CriterionDTO.from((FieldName)FieldName.SUBJECT, (Operator)Operator.CONTAINS, (String)"subject"), CriterionDTO.from((FieldName)FieldName.SENDER, (Operator)Operator.EQUALS, (String)MailAddressFixture.SENDER.asString())}), CriterionDTO.from((FieldName)FieldName.HAS_ATTACHMENT, (Operator)Operator.EQUALS, (String)"true")}));
    }

    @Test
    void shouldDeserializeFlattenStructure() throws Exception {
        String queryJson = "{    \"combinator\": \"and\",    \"criteria\": [      {\"fieldName\": \"subject\", \"operator\": \"contains\", \"value\": \"subject\"},    {\"fieldName\": \"sender\", \"operator\": \"equals\", \"value\": \"" + MailAddressFixture.SENDER.asString() + "\"},    {\"fieldName\": \"hasAttachment\", \"operator\": \"equals\", \"value\": \"true\"}  ]  }  ";
        QueryDTO queryDTO = (QueryDTO)this.objectMapper.readValue(queryJson, QueryDTO.class);
        Assertions.assertThat((Object)queryDTO).isEqualTo((Object)QueryDTO.and((QueryElement[])new QueryElement[]{CriterionDTO.from((FieldName)FieldName.SUBJECT, (Operator)Operator.CONTAINS, (String)"subject"), CriterionDTO.from((FieldName)FieldName.SENDER, (Operator)Operator.EQUALS, (String)MailAddressFixture.SENDER.asString()), CriterionDTO.from((FieldName)FieldName.HAS_ATTACHMENT, (Operator)Operator.EQUALS, (String)"true")}));
    }
}

