/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import javax.mail.internet.AddressException;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageFixture;
import org.apache.james.vault.dto.DeletedMessageWithStorageInformationConverter;
import org.apache.james.vault.dto.DeletedMessageWithStorageInformationDTO;
import org.apache.james.vault.metadata.DeletedMessageVaultMetadataFixture;
import org.apache.james.vault.metadata.DeletedMessageWithStorageInformation;
import org.apache.james.vault.metadata.StorageInformation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DeletedMessageWithStorageInformationDTOTest {
    private static final DeletedMessageWithStorageInformationDTO.StorageInformationDTO STORAGE_INFORMATION_DTO = DeletedMessageWithStorageInformationDTO.StorageInformationDTO.toDTO((StorageInformation)DeletedMessageVaultMetadataFixture.STORAGE_INFORMATION);
    private static final DeletedMessageWithStorageInformationDTO.DeletedMessageDTO DELETED_MESSAGE_DTO = DeletedMessageWithStorageInformationDTO.DeletedMessageDTO.toDTO((DeletedMessage)DeletedMessageFixture.DELETED_MESSAGE);
    private static final DeletedMessageWithStorageInformationDTO.DeletedMessageDTO DELETED_MESSAGE_WITH_SUBJECT_DTO = DeletedMessageWithStorageInformationDTO.DeletedMessageDTO.toDTO((DeletedMessage)DeletedMessageFixture.DELETED_MESSAGE_WITH_SUBJECT);
    private static final DeletedMessageWithStorageInformation DELETED_MESSAGE_WITH_STORAGE_INFO = new DeletedMessageWithStorageInformation(DeletedMessageFixture.DELETED_MESSAGE_WITH_SUBJECT, DeletedMessageVaultMetadataFixture.STORAGE_INFORMATION);
    private static final DeletedMessageWithStorageInformationDTO DELETED_MESSAGE_WITH_STORAGE_INFO_DTO = DeletedMessageWithStorageInformationDTO.toDTO((DeletedMessageWithStorageInformation)DELETED_MESSAGE_WITH_STORAGE_INFO);
    private static final String STORAGE_INFORMATION_JSON = ClassLoaderUtils.getSystemResourceAsString((String)"json/storage_information.json");
    private static final String DELETED_MESSAGE_JSON = ClassLoaderUtils.getSystemResourceAsString((String)"json/deleted_message.json");
    private static final String DELETED_MESSAGE_WITH_SUBJECT_JSON = ClassLoaderUtils.getSystemResourceAsString((String)"json/deleted_message_with_subject.json");
    private static final String DELETED_MESSAGE_WITH_STORAGE_INFO_JSON = ClassLoaderUtils.getSystemResourceAsString((String)"json/deleted_message_with_storage_information.json");
    private ObjectMapper objectMapper;
    private DeletedMessageWithStorageInformationConverter converter;

    DeletedMessageWithStorageInformationDTOTest() {
    }

    @BeforeEach
    void setup() {
        this.objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        this.converter = new DeletedMessageWithStorageInformationConverter((BlobId.Factory)new HashBlobId.Factory(), (MessageId.Factory)new InMemoryMessageId.Factory(), (MailboxId.Factory)new InMemoryId.Factory());
    }

    @Test
    void shouldSerializeStorageInformation() throws Exception {
        JsonAssertions.assertThatJson((Object)this.objectMapper.writeValueAsString((Object)STORAGE_INFORMATION_DTO)).isEqualTo((Object)STORAGE_INFORMATION_JSON);
    }

    @Test
    void shouldDeserializeStorageInformation() throws Exception {
        Assertions.assertThat((Object)this.converter.toDomainObject((DeletedMessageWithStorageInformationDTO.StorageInformationDTO)this.objectMapper.readValue(STORAGE_INFORMATION_JSON, DeletedMessageWithStorageInformationDTO.StorageInformationDTO.class))).isEqualTo((Object)DeletedMessageVaultMetadataFixture.STORAGE_INFORMATION);
    }

    @Test
    void shouldSerializeDeletedMessage() throws Exception {
        JsonAssertions.assertThatJson((Object)this.objectMapper.writeValueAsString((Object)DELETED_MESSAGE_DTO)).isEqualTo((Object)DELETED_MESSAGE_JSON);
    }

    @Test
    void shouldDeserializeDeletedMessage() throws Exception {
        Assertions.assertThat((Object)this.converter.toDomainObject((DeletedMessageWithStorageInformationDTO.DeletedMessageDTO)this.objectMapper.readValue(DELETED_MESSAGE_JSON, DeletedMessageWithStorageInformationDTO.DeletedMessageDTO.class))).isEqualTo((Object)DeletedMessageFixture.DELETED_MESSAGE);
    }

    @Test
    void shouldSerializeDeletedMessageWithSubject() throws Exception {
        JsonAssertions.assertThatJson((Object)this.objectMapper.writeValueAsString((Object)DELETED_MESSAGE_WITH_SUBJECT_DTO)).isEqualTo((Object)DELETED_MESSAGE_WITH_SUBJECT_JSON);
    }

    @Test
    void shouldDeserializeDeletedMessageWithSubject() throws Exception {
        Assertions.assertThat((Object)this.converter.toDomainObject((DeletedMessageWithStorageInformationDTO.DeletedMessageDTO)this.objectMapper.readValue(DELETED_MESSAGE_WITH_SUBJECT_JSON, DeletedMessageWithStorageInformationDTO.DeletedMessageDTO.class))).isEqualTo((Object)DeletedMessageFixture.DELETED_MESSAGE_WITH_SUBJECT);
    }

    @Test
    void shouldSerializeDeletedMessageWithStorageInformation() throws Exception {
        JsonAssertions.assertThatJson((Object)this.objectMapper.writeValueAsString((Object)DELETED_MESSAGE_WITH_STORAGE_INFO_DTO)).isEqualTo((Object)DELETED_MESSAGE_WITH_STORAGE_INFO_JSON);
    }

    @Test
    void shouldDeserializeDeletedMessageWithStorageInformation() throws Exception {
        Assertions.assertThat((Object)this.converter.toDomainObject((DeletedMessageWithStorageInformationDTO)this.objectMapper.readValue(DELETED_MESSAGE_WITH_STORAGE_INFO_JSON, DeletedMessageWithStorageInformationDTO.class))).isEqualTo((Object)DELETED_MESSAGE_WITH_STORAGE_INFO);
    }

    @Test
    void deserializingInvalidAddressesShouldThrow() {
        Assertions.assertThatThrownBy(() -> this.converter.toDomainObject((DeletedMessageWithStorageInformationDTO)this.objectMapper.readValue(ClassLoaderUtils.getSystemResourceAsString((String)"json/deleted_message_with_storage_information_invalid.json"), DeletedMessageWithStorageInformationDTO.class))).isInstanceOf(AddressException.class);
    }
}

