/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.blob;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.blob.api.BucketName;
import org.apache.james.vault.blob.BucketNameGenerator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class BucketNameGeneratorTest {
    private static final Instant NOW = Instant.parse("2007-12-03T10:15:30.00Z");
    private static final Instant DATE_2 = Instant.parse("2007-07-03T10:15:30.00Z");
    private static final Clock CLOCK = Clock.fixed(NOW, ZoneId.of("UTC"));
    private static final BucketNameGenerator DEFAULT_GENERATOR = new BucketNameGenerator(CLOCK);
    private static final Clock CLOCK_2 = Clock.fixed(DATE_2, ZoneId.of("UTC"));

    BucketNameGeneratorTest() {
    }

    @Test
    void currentBucketShouldReturnBucketFormattedOnFirstDayOfMonth() {
        Assertions.assertThat((Object)DEFAULT_GENERATOR.currentBucket()).isEqualTo((Object)BucketName.of((String)"deleted-messages-2007-12-01"));
    }

    @Test
    void monthShouldBeFormattedWithTwoDigits() {
        Assertions.assertThat((Object)new BucketNameGenerator(CLOCK_2).currentBucket()).isEqualTo((Object)BucketName.of((String)"deleted-messages-2007-07-01"));
    }

    @Nested
    class IsBucketRangeBefore {
        IsBucketRangeBefore() {
        }

        @ParameterizedTest
        @ValueSource(strings={"deleted-Messages-2018-07-01", "deleted-Messages-2018-07-02", "deletedMessages-2018-07-01", "deletedMessages-2018-007-01", "deletedMessages-2018-07-001", "2018-07-01", "2018-01-07", "01-07-2018"})
        void shouldBeEmptyWhenPassingNonWellFormattedBucketNames(String bucketNameAsString) {
            BucketName bucketName = BucketName.of((String)bucketNameAsString);
            Assertions.assertThat((Optional)DEFAULT_GENERATOR.bucketEndTime(bucketName)).isEmpty();
        }

        @Test
        void shouldBeFalseWhenBucketNameIsInSameMonthWithPassedTime() {
            BucketName bucketName = BucketName.of((String)"deleted-messages-2019-07-01");
            Assertions.assertThat((Optional)DEFAULT_GENERATOR.bucketEndTime(bucketName)).contains((Object)ZonedDateTime.parse("2019-08-01T00:00:00.000000000Z[UTC]"));
        }
    }
}

