/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.blob;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.blob.api.BucketName;
import org.apache.james.server.task.json.JsonTaskAdditionalInformationSerializer;
import org.apache.james.server.task.json.JsonTaskSerializer;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.vault.blob.BlobStoreDeletedMessageVault;
import org.apache.james.vault.blob.BlobStoreVaultGarbageCollectionTask;
import org.apache.james.vault.blob.BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO;
import org.apache.james.vault.blob.BlobStoreVaultGarbageCollectionTaskDTO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import reactor.core.publisher.Flux;

class BlobStoreVaultGarbageCollectionTaskSerializationTest {
    private static final BlobStoreDeletedMessageVault DELETED_MESSAGE_VAULT = (BlobStoreDeletedMessageVault)Mockito.mock(BlobStoreDeletedMessageVault.class);
    private static final BlobStoreVaultGarbageCollectionTask.Factory TASK_FACTORY = new BlobStoreVaultGarbageCollectionTask.Factory(DELETED_MESSAGE_VAULT);
    private static final JsonTaskSerializer TASK_SERIALIZER = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{BlobStoreVaultGarbageCollectionTaskDTO.module((BlobStoreVaultGarbageCollectionTask.Factory)TASK_FACTORY)});
    private static final ZonedDateTime BEGINNING_OF_RETENTION_PERIOD = ZonedDateTime.parse("2019-09-03T15:26:13.356+02:00[Europe/Paris]");
    private static final ImmutableSet<BucketName> BUCKET_IDS = ImmutableSet.of((Object)BucketName.of((String)"1"), (Object)BucketName.of((String)"2"), (Object)BucketName.of((String)"3"));
    private static final Flux<BucketName> RETENTION_OPERATION = Flux.fromIterable(BUCKET_IDS);
    private static final Instant TIMESTAMP = Instant.parse("2018-11-13T12:00:55Z");
    private static final BlobStoreVaultGarbageCollectionTask.AdditionalInformation DETAILS = new BlobStoreVaultGarbageCollectionTask.AdditionalInformation(BEGINNING_OF_RETENTION_PERIOD, BUCKET_IDS, TIMESTAMP);
    private static final BlobStoreVaultGarbageCollectionTask TASK = TASK_FACTORY.create();
    private static final String SERIALIZED_TASK = "{\"type\":\"deleted-messages-blob-store-based-garbage-collection\"}";
    private static final String SERIALIZED_ADDITIONAL_INFORMATION_TASK = "{\"type\":\"deleted-messages-blob-store-based-garbage-collection\", \"beginningOfRetentionPeriod\":\"2019-09-03T15:26:13.356+02:00[Europe/Paris]\",\"deletedBuckets\":[\"1\", \"2\", \"3\"], \"timestamp\": \"2018-11-13T12:00:55Z\"}";
    private static final JsonTaskAdditionalInformationSerializer JSON_TASK_ADDITIONAL_INFORMATION_SERIALIZER = JsonTaskAdditionalInformationSerializer.of((AdditionalInformationDTOModule[])new AdditionalInformationDTOModule[]{BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO.MODULE});

    BlobStoreVaultGarbageCollectionTaskSerializationTest() {
    }

    @BeforeAll
    static void setUp() {
        Mockito.when((Object)DELETED_MESSAGE_VAULT.getBeginningOfRetentionPeriod()).thenReturn((Object)BEGINNING_OF_RETENTION_PERIOD);
        Mockito.when((Object)DELETED_MESSAGE_VAULT.deleteExpiredMessages((ZonedDateTime)ArgumentMatchers.any())).thenReturn(RETENTION_OPERATION);
    }

    @Test
    void taskShouldBeSerializable() throws JsonProcessingException {
        JsonAssertions.assertThatJson((Object)TASK_SERIALIZER.serialize((Task)TASK)).isEqualTo((Object)SERIALIZED_TASK);
    }

    @Test
    void taskShouldBeDeserializable() throws IOException {
        Task deserialized = TASK_SERIALIZER.deserialize(SERIALIZED_TASK);
        Assertions.assertThat((Object)deserialized).isInstanceOf(BlobStoreVaultGarbageCollectionTask.class);
    }

    @Test
    void additionalInformationShouldBeSerializable() throws JsonProcessingException {
        JsonAssertions.assertThatJson((Object)JSON_TASK_ADDITIONAL_INFORMATION_SERIALIZER.serialize((TaskExecutionDetails.AdditionalInformation)DETAILS)).isEqualTo((Object)SERIALIZED_ADDITIONAL_INFORMATION_TASK);
    }

    @Test
    void additonalInformationShouldBeDeserializable() throws IOException {
        Assertions.assertThat((Object)JSON_TASK_ADDITIONAL_INFORMATION_SERIALIZER.deserialize(SERIALIZED_ADDITIONAL_INFORMATION_TASK)).isEqualToComparingFieldByField((Object)DETAILS);
    }
}

