/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.blob;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.stream.Stream;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.memory.MemoryBlobStore;
import org.apache.james.blob.memory.MemoryDumbBlobStore;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.utils.UpdatableTickingClock;
import org.apache.james.vault.DeletedMessageFixture;
import org.apache.james.vault.DeletedMessageVault;
import org.apache.james.vault.DeletedMessageVaultContract;
import org.apache.james.vault.DeletedMessageVaultSearchContract;
import org.apache.james.vault.RetentionConfiguration;
import org.apache.james.vault.blob.BlobStoreDeletedMessageVault;
import org.apache.james.vault.blob.BucketNameGenerator;
import org.apache.james.vault.memory.metadata.MemoryDeletedMessageMetadataVault;
import org.apache.james.vault.metadata.DeletedMessageMetadataVault;
import org.apache.james.vault.search.Query;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class BlobStoreDeletedMessageVaultTest
implements DeletedMessageVaultContract,
DeletedMessageVaultSearchContract.AllContracts {
    private BlobStoreDeletedMessageVault messageVault;
    private UpdatableTickingClock clock;
    private RecordingMetricFactory metricFactory;

    BlobStoreDeletedMessageVaultTest() {
    }

    @BeforeEach
    void setUp() {
        this.clock = new UpdatableTickingClock(DeletedMessageFixture.NOW.toInstant());
        this.metricFactory = new RecordingMetricFactory();
        this.messageVault = new BlobStoreDeletedMessageVault((MetricFactory)this.metricFactory, (DeletedMessageMetadataVault)new MemoryDeletedMessageMetadataVault(), (BlobStore)new MemoryBlobStore((BlobId.Factory)new HashBlobId.Factory(), new MemoryDumbBlobStore()), new BucketNameGenerator((Clock)this.clock), (Clock)this.clock, RetentionConfiguration.DEFAULT);
    }

    @Override
    public DeletedMessageVault getVault() {
        return this.messageVault;
    }

    @Override
    public UpdatableTickingClock getClock() {
        return this.clock;
    }

    @Test
    void retentionQualifiedBucketsShouldReturnOnlyBucketsFullyBeforeBeginningOfRetentionPeriod() {
        this.clock.setInstant(Instant.parse("2007-12-03T10:15:30.00Z"));
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.OLD_DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        this.clock.setInstant(Instant.parse("2008-01-03T10:15:30.00Z"));
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE_2, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        ZonedDateTime beginningOfRetention = ZonedDateTime.parse("2008-01-30T10:15:30.00Z");
        Assertions.assertThat((Stream)this.messageVault.retentionQualifiedBuckets(beginningOfRetention).toStream()).containsOnly((Object[])new BucketName[]{BucketName.of((String)"deleted-messages-2007-12-01")});
    }

    @Test
    void retentionQualifiedBucketsShouldReturnAllWhenAllBucketMonthAreBeforeBeginningOfRetention() {
        this.clock.setInstant(Instant.parse("2007-12-03T10:15:30.00Z"));
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.OLD_DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        this.clock.setInstant(Instant.parse("2008-01-30T10:15:30.00Z"));
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE_2, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Assertions.assertThat((Stream)this.messageVault.retentionQualifiedBuckets(ZonedDateTime.parse("2008-02-01T10:15:30.00Z")).toStream()).containsOnly((Object[])new BucketName[]{BucketName.of((String)"deleted-messages-2007-12-01"), BucketName.of((String)"deleted-messages-2008-01-01")});
    }

    @Test
    void appendShouldPublishAppendTimerMetrics() {
        Mono.from((Publisher)this.messageVault.append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Mono.from((Publisher)this.messageVault.append(DeletedMessageFixture.DELETED_MESSAGE_2, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Assertions.assertThat((Iterable)this.metricFactory.executionTimesFor("deletedMessageVault:blobStore:append")).hasSize(2);
    }

    @Test
    void searchShouldPublishSearchTimerMetrics() {
        Mono.from((Publisher)this.messageVault.search(DeletedMessageFixture.USERNAME, Query.ALL)).block();
        Mono.from((Publisher)this.messageVault.search(DeletedMessageFixture.USERNAME, Query.ALL)).block();
        Assertions.assertThat((Iterable)this.metricFactory.executionTimesFor("deletedMessageVault:blobStore:search")).hasSize(2);
    }

    @Test
    void loadMimeMessageShouldPublishLoadMimeMessageTimerMetrics() {
        Mono.from((Publisher)this.messageVault.loadMimeMessage(DeletedMessageFixture.USERNAME, (MessageId)DeletedMessageFixture.MESSAGE_ID)).block();
        Mono.from((Publisher)this.messageVault.loadMimeMessage(DeletedMessageFixture.USERNAME, (MessageId)DeletedMessageFixture.MESSAGE_ID)).block();
        Assertions.assertThat((Iterable)this.metricFactory.executionTimesFor("deletedMessageVault:blobStore:loadMimeMessage")).hasSize(2);
    }

    @Test
    void deleteShouldPublishDeleteTimerMetrics() {
        Mono.from((Publisher)this.messageVault.delete(DeletedMessageFixture.USERNAME, (MessageId)DeletedMessageFixture.MESSAGE_ID)).block();
        Mono.from((Publisher)this.messageVault.delete(DeletedMessageFixture.USERNAME, (MessageId)DeletedMessageFixture.MESSAGE_ID)).block();
        Assertions.assertThat((Iterable)this.metricFactory.executionTimesFor("deletedMessageVault:blobStore:delete")).hasSize(2);
    }

    @Test
    void deleteExpiredMessagesTaskShouldPublishRetentionTimerMetrics() throws Exception {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Mono.from((Publisher)this.getVault().delete(DeletedMessageFixture.USERNAME, DeletedMessageFixture.DELETED_MESSAGE.getMessageId())).block();
        this.getVault().deleteExpiredMessagesTask().run();
        Assertions.assertThat((Iterable)this.metricFactory.executionTimesFor("deletedMessageVault:blobStore:deleteExpiredMessages")).hasSize(1);
    }
}

