/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import java.time.Duration;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.james.vault.RetentionConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RetentionConfigurationTest {
    RetentionConfigurationTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(RetentionConfiguration.class).verify();
    }

    @Test
    void constructorShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> new RetentionConfiguration(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> RetentionConfiguration.from(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromShouldReturnConfiguredRetentionTime() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("retentionPeriod", (Object)"15d");
        Assertions.assertThat((Object)RetentionConfiguration.from((Configuration)configuration)).isEqualTo((Object)new RetentionConfiguration(Duration.ofDays(15L)));
    }

    @Test
    void fromShouldHandleHours() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("retentionPeriod", (Object)"15h");
        Assertions.assertThat((Object)RetentionConfiguration.from((Configuration)configuration)).isEqualTo((Object)new RetentionConfiguration(Duration.ofHours(15L)));
    }

    @Test
    void fromShouldUseDaysAsADefaultUnit() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("retentionPeriod", (Object)"15");
        Assertions.assertThat((Object)RetentionConfiguration.from((Configuration)configuration)).isEqualTo((Object)new RetentionConfiguration(Duration.ofDays(15L)));
    }

    @Test
    void fromShouldReturnDefaultWhenNoRetentionTime() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        Assertions.assertThat((Object)RetentionConfiguration.from((Configuration)configuration)).isEqualTo((Object)RetentionConfiguration.DEFAULT);
    }
}

