/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import com.github.fge.lambdas.Throwing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.james.mailbox.backup.ZipAssert;
import org.apache.james.mailbox.backup.zip.MessageIdExtraField;
import org.apache.james.mailbox.backup.zip.SizeExtraField;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageFixture;
import org.apache.james.vault.DeletedMessageZipper;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class DeletedMessageZipperTest {
    private static final DeletedMessageZipper.DeletedMessageContentLoader CONTENT_LOADER = message -> Optional.of(new ByteArrayInputStream(DeletedMessageFixture.CONTENT));
    private static final String MESSAGE_CONTENT = new String(DeletedMessageFixture.CONTENT, StandardCharsets.UTF_8);
    private DeletedMessageZipper zipper;

    DeletedMessageZipperTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.zipper = (DeletedMessageZipper)Mockito.spy((Object)new DeletedMessageZipper());
    }

    private DeletedMessageZipper.DeletedMessageContentLoader spyLoadedContents(Collection<InputStream> loadedContents) {
        Answer spyedContent = invocationOnMock -> {
            InputStream spied = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(DeletedMessageFixture.CONTENT));
            loadedContents.add(spied);
            return Optional.of(spied);
        };
        DeletedMessageZipper.DeletedMessageContentLoader contentLoader = (DeletedMessageZipper.DeletedMessageContentLoader)Mockito.mock(DeletedMessageZipper.DeletedMessageContentLoader.class);
        Mockito.when((Object)contentLoader.load((DeletedMessage)ArgumentMatchers.any())).thenAnswer(spyedContent);
        return contentLoader;
    }

    private Answer<ZipArchiveOutputStream> spyZipOutPutStream(AtomicReference<ZipArchiveOutputStream> spiedZipArchiveOutputStream) {
        return invocation -> {
            ZipArchiveOutputStream zipArchiveOutputStream = (ZipArchiveOutputStream)Mockito.spy((Object)((ZipArchiveOutputStream)invocation.callRealMethod()));
            spiedZipArchiveOutputStream.set(zipArchiveOutputStream);
            return zipArchiveOutputStream;
        };
    }

    @Nested
    class FailingBehaviourTest {
        FailingBehaviourTest() {
        }

        @Test
        void zipShouldThrowWhenCreateEntryGetException() throws Exception {
            ((DeletedMessageZipper)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("mocked exception")}).when((Object)DeletedMessageZipperTest.this.zipper)).createEntry((ZipArchiveOutputStream)ArgumentMatchers.any(), (DeletedMessage)ArgumentMatchers.any());
            Assertions.assertThatThrownBy(() -> DeletedMessageZipperTest.this.zipper.zip(CONTENT_LOADER, Stream.of(DeletedMessageFixture.DELETED_MESSAGE, DeletedMessageFixture.DELETED_MESSAGE_2), (OutputStream)new ByteArrayOutputStream())).isInstanceOf(IOException.class);
        }

        @Test
        void zipShouldThrowWhenPutMessageToEntryGetException() throws Exception {
            ((DeletedMessageZipper)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("mocked exception")}).when((Object)DeletedMessageZipperTest.this.zipper)).putMessageToEntry((ZipArchiveOutputStream)ArgumentMatchers.any(), (DeletedMessage)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
            Assertions.assertThatThrownBy(() -> DeletedMessageZipperTest.this.zipper.zip(CONTENT_LOADER, Stream.of(DeletedMessageFixture.DELETED_MESSAGE, DeletedMessageFixture.DELETED_MESSAGE_2), (OutputStream)new ByteArrayOutputStream())).isInstanceOf(IOException.class);
        }

        @Test
        void zipShouldTerminateZipArchiveStreamWhenGettingException() throws Exception {
            ((DeletedMessageZipper)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("mocked exception")}).when((Object)DeletedMessageZipperTest.this.zipper)).putMessageToEntry((ZipArchiveOutputStream)ArgumentMatchers.any(), (DeletedMessage)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
            AtomicReference zipOutputStreamReference = new AtomicReference();
            Mockito.when((Object)DeletedMessageZipperTest.this.zipper.newZipArchiveOutputStream((OutputStream)ArgumentMatchers.any())).thenAnswer(DeletedMessageZipperTest.this.spyZipOutPutStream(zipOutputStreamReference));
            try {
                DeletedMessageZipperTest.this.zipper.zip(CONTENT_LOADER, Stream.of(DeletedMessageFixture.DELETED_MESSAGE, DeletedMessageFixture.DELETED_MESSAGE_2), (OutputStream)new ByteArrayOutputStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((ZipArchiveOutputStream)Mockito.verify((Object)((ZipArchiveOutputStream)zipOutputStreamReference.get()), (VerificationMode)Mockito.times((int)1))).finish();
            ((ZipArchiveOutputStream)Mockito.verify((Object)((ZipArchiveOutputStream)zipOutputStreamReference.get()), (VerificationMode)Mockito.times((int)1))).close();
        }

        @Test
        void zipShouldCloseParameterOutputStreamWhenGettingException() throws Exception {
            ((DeletedMessageZipper)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("mocked exception")}).when((Object)DeletedMessageZipperTest.this.zipper)).putMessageToEntry((ZipArchiveOutputStream)ArgumentMatchers.any(), (DeletedMessage)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)Mockito.spy((Object)new ByteArrayOutputStream());
            try {
                DeletedMessageZipperTest.this.zipper.zip(CONTENT_LOADER, Stream.of(DeletedMessageFixture.DELETED_MESSAGE), (OutputStream)outputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((ByteArrayOutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.times((int)1))).close();
        }

        @Test
        void zipShouldStopLoadingResourcesWhenGettingException() throws Exception {
            ((DeletedMessageZipper)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("mocked exception")}).when((Object)DeletedMessageZipperTest.this.zipper)).createEntry((ZipArchiveOutputStream)ArgumentMatchers.any(), (DeletedMessage)ArgumentMatchers.any());
            DeletedMessageZipper.DeletedMessageContentLoader contentLoader = (DeletedMessageZipper.DeletedMessageContentLoader)Mockito.spy((Object)new DeletedMessageZipper.DeletedMessageContentLoader(){

                public Optional<InputStream> load(DeletedMessage deletedMessage) {
                    return Optional.of(new ByteArrayInputStream(DeletedMessageFixture.CONTENT));
                }
            });
            try {
                DeletedMessageZipperTest.this.zipper.zip(contentLoader, Stream.of(DeletedMessageFixture.DELETED_MESSAGE, DeletedMessageFixture.DELETED_MESSAGE_2), (OutputStream)new ByteArrayOutputStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((DeletedMessageZipper.DeletedMessageContentLoader)Mockito.verify((Object)contentLoader, (VerificationMode)Mockito.times((int)1))).load((DeletedMessage)ArgumentMatchers.any());
        }

        @Test
        void zipShouldNotPutEntryIfContentLoaderReturnsEmptyResult() throws Exception {
            DeletedMessageZipper.DeletedMessageContentLoader contentLoader = message -> Optional.empty();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DeletedMessageZipperTest.this.zipper.zip(contentLoader, Stream.of(DeletedMessageFixture.DELETED_MESSAGE, DeletedMessageFixture.DELETED_MESSAGE_2), (OutputStream)outputStream);
            try (ZipAssert zipAssert = ZipAssert.assertThatZip((ByteArrayOutputStream)outputStream);){
                zipAssert.hasNoEntry();
            }
        }
    }

    @Nested
    class NormalBehaviourTest {
        NormalBehaviourTest() {
        }

        @Test
        void constructorShouldNotFailWhenCalledMultipleTimes() {
            Assertions.assertThatCode(() -> {
                new DeletedMessageZipper();
                new DeletedMessageZipper();
            }).doesNotThrowAnyException();
        }

        @Test
        void zipShouldPutEntriesToOutputStream() throws Exception {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DeletedMessageZipperTest.this.zipper.zip(CONTENT_LOADER, Stream.of(DeletedMessageFixture.DELETED_MESSAGE, DeletedMessageFixture.DELETED_MESSAGE_2), (OutputStream)outputStream);
            try (ZipAssert zipAssert = ZipAssert.assertThatZip((ByteArrayOutputStream)outputStream);){
                zipAssert.containsOnlyEntriesMatching(new ZipAssert.EntryChecks[]{ZipAssert.EntryChecks.hasName((String)(DeletedMessageFixture.MESSAGE_ID.serialize() + ".eml")).hasStringContent(MESSAGE_CONTENT), ZipAssert.EntryChecks.hasName((String)(DeletedMessageFixture.MESSAGE_ID_2.serialize() + ".eml")).hasStringContent(MESSAGE_CONTENT)});
            }
        }

        @Test
        void zipShouldPutExtraFields() throws Exception {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DeletedMessageZipperTest.this.zipper.zip(CONTENT_LOADER, Stream.of(DeletedMessageFixture.DELETED_MESSAGE), (OutputStream)outputStream);
            try (ZipAssert zipAssert = ZipAssert.assertThatZip((ByteArrayOutputStream)outputStream);){
                zipAssert.containsOnlyEntriesMatching(new ZipAssert.EntryChecks[]{ZipAssert.EntryChecks.hasName((String)(DeletedMessageFixture.MESSAGE_ID.serialize() + ".eml")).containsExtraFields(new ZipExtraField[]{new MessageIdExtraField((MessageId)DeletedMessageFixture.MESSAGE_ID)}).containsExtraFields(new ZipExtraField[]{new SizeExtraField((long)DeletedMessageFixture.CONTENT.length)})});
            }
        }

        @Test
        void zipShouldTerminateZipArchiveStreamWhenFinishZipping() throws Exception {
            AtomicReference zipOutputStreamReference = new AtomicReference();
            Mockito.when((Object)DeletedMessageZipperTest.this.zipper.newZipArchiveOutputStream((OutputStream)ArgumentMatchers.any())).thenAnswer(DeletedMessageZipperTest.this.spyZipOutPutStream(zipOutputStreamReference));
            DeletedMessageZipperTest.this.zipper.zip(CONTENT_LOADER, Stream.of(DeletedMessageFixture.DELETED_MESSAGE, DeletedMessageFixture.DELETED_MESSAGE_2), (OutputStream)new ByteArrayOutputStream());
            ((ZipArchiveOutputStream)Mockito.verify((Object)((ZipArchiveOutputStream)zipOutputStreamReference.get()), (VerificationMode)Mockito.times((int)1))).finish();
            ((ZipArchiveOutputStream)Mockito.verify((Object)((ZipArchiveOutputStream)zipOutputStreamReference.get()), (VerificationMode)Mockito.times((int)1))).close();
        }

        @Test
        void zipShouldCloseAllResourcesStreamWhenFinishZipping() throws Exception {
            ConcurrentLinkedQueue loadedContents = new ConcurrentLinkedQueue();
            DeletedMessageZipperTest.this.zipper.zip(DeletedMessageZipperTest.this.spyLoadedContents(loadedContents), Stream.of(DeletedMessageFixture.DELETED_MESSAGE, DeletedMessageFixture.DELETED_MESSAGE_2), (OutputStream)new ByteArrayOutputStream());
            ((IterableAssert)Assertions.assertThat(loadedContents).hasSize(2)).allSatisfy((Consumer)Throwing.consumer(content -> ((InputStream)Mockito.verify((Object)content, (VerificationMode)Mockito.times((int)1))).close()));
        }
    }
}

