/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageFixture;
import org.apache.james.vault.DeletedMessageVault;
import org.apache.james.vault.search.Criterion;
import org.apache.james.vault.search.CriterionFactory;
import org.apache.james.vault.search.Query;
import org.apache.mailet.base.MailAddressFixture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DeletedMessageVaultSearchContract {
    public static final AtomicLong MESSAGE_ID_GENERATOR = new AtomicLong(0L);

    public DeletedMessageVault getVault();

    default public List<DeletedMessage> search(Query query) {
        return this.search(DeletedMessageFixture.USERNAME, query);
    }

    default public List<DeletedMessage> search(Username username, Query query) {
        return (List)Flux.from((Publisher)this.getVault().search(username, query)).collectList().block();
    }

    default public DeletedMessage storeMessageWithDeliveryDate(ZonedDateTime deliveryDate) {
        DeletedMessage deletedMessage = this.defaultDeletedMessageFinalStage(deliveryDate, DeletedMessageFixture.DELETION_DATE).build();
        return this.storeDeletedMessage(deletedMessage);
    }

    default public DeletedMessage storeMessageWithDeletionDate(ZonedDateTime delitionDate) {
        DeletedMessage deletedMessage = this.defaultDeletedMessageFinalStage(DeletedMessageFixture.DELIVERY_DATE, delitionDate).build();
        return this.storeDeletedMessage(deletedMessage);
    }

    default public DeletedMessage storeMessageWithRecipients(MailAddress ... recipients) {
        DeletedMessage deletedMessage = ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId((MessageId)InMemoryMessageId.of((long)MESSAGE_ID_GENERATOR.incrementAndGet()))).originMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_1})).user(DeletedMessageFixture.USERNAME)).deliveryDate(DeletedMessageFixture.DELIVERY_DATE)).deletionDate(DeletedMessageFixture.DELETION_DATE)).sender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER))).recipients(recipients)).hasAttachment(false)).size((long)DeletedMessageFixture.CONTENT.length)).build();
        return this.storeDeletedMessage(deletedMessage);
    }

    default public DeletedMessage storeMessageWithSender(MaybeSender sender) {
        DeletedMessage deletedMessage = ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId((MessageId)InMemoryMessageId.of((long)MESSAGE_ID_GENERATOR.incrementAndGet()))).originMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_1})).user(DeletedMessageFixture.USERNAME)).deliveryDate(DeletedMessageFixture.DELIVERY_DATE)).deletionDate(DeletedMessageFixture.DELETION_DATE)).sender(sender)).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2})).hasAttachment(false)).size((long)DeletedMessageFixture.CONTENT.length)).build();
        return this.storeDeletedMessage(deletedMessage);
    }

    default public DeletedMessage storeMessageWithHasAttachment(boolean hasAttachment) {
        DeletedMessage deletedMessage = ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId((MessageId)InMemoryMessageId.of((long)MESSAGE_ID_GENERATOR.incrementAndGet()))).originMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_1})).user(DeletedMessageFixture.USERNAME)).deliveryDate(DeletedMessageFixture.DELIVERY_DATE)).deletionDate(DeletedMessageFixture.DELETION_DATE)).sender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER))).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2})).hasAttachment(hasAttachment)).size((long)DeletedMessageFixture.CONTENT.length)).build();
        return this.storeDeletedMessage(deletedMessage);
    }

    default public DeletedMessage storeMessageWithOriginMailboxes(MailboxId ... originMailboxIds) {
        DeletedMessage deletedMessage = ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId((MessageId)InMemoryMessageId.of((long)MESSAGE_ID_GENERATOR.incrementAndGet()))).originMailboxes(originMailboxIds)).user(DeletedMessageFixture.USERNAME)).deliveryDate(DeletedMessageFixture.DELIVERY_DATE)).deletionDate(DeletedMessageFixture.DELETION_DATE)).sender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER))).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2})).hasAttachment(true)).size((long)DeletedMessageFixture.CONTENT.length)).build();
        return this.storeDeletedMessage(deletedMessage);
    }

    default public DeletedMessage storeMessageNoSubject() {
        DeletedMessage deletedMessage = this.defaultDeletedMessageFinalStage(DeletedMessageFixture.DELIVERY_DATE, DeletedMessageFixture.DELETION_DATE).build();
        return this.storeDeletedMessage(deletedMessage);
    }

    default public DeletedMessage storeMessageWithSubject(String subject) {
        DeletedMessage deletedMessage = this.defaultDeletedMessageFinalStage(DeletedMessageFixture.DELIVERY_DATE, DeletedMessageFixture.DELETION_DATE).subject(subject).build();
        return this.storeDeletedMessage(deletedMessage);
    }

    default public DeletedMessage storeDefaultMessage() {
        DeletedMessage deletedMessage = this.defaultDeletedMessageFinalStage(DeletedMessageFixture.DELIVERY_DATE, DeletedMessageFixture.DELETION_DATE).subject("subject").build();
        return this.storeDeletedMessage(deletedMessage);
    }

    default public DeletedMessage storeDeletedMessage(DeletedMessage deletedMessage) {
        Mono.from((Publisher)this.getVault().append(deletedMessage, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        return deletedMessage;
    }

    default public DeletedMessage.Builder.FinalStage defaultDeletedMessageFinalStage(ZonedDateTime deliveryDate, ZonedDateTime deletionDate) {
        return (DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId((MessageId)InMemoryMessageId.of((long)MESSAGE_ID_GENERATOR.incrementAndGet()))).originMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_1})).user(DeletedMessageFixture.USERNAME)).deliveryDate(deliveryDate)).deletionDate(deletionDate)).sender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER))).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1})).hasAttachment(false)).size((long)DeletedMessageFixture.CONTENT.length);
    }

    public static interface StringByLocaleContract
    extends DeletedMessageVaultSearchContract {
        @Disabled(value="MAILBOX-384 DeletedMessageVault search will return a wrong result in case of using string equalsIgnoreCase with a special locale")
        @Test
        default public void shouldReturnsMessageWhenPassingAStringInDifferentLocaleToContainsIgnoreCase() {
            Locale turkishLocale = Locale.forLanguageTag("tr");
            String subjectInTurkishLanguage = "TITLE";
            DeletedMessage message1 = this.storeMessageWithSubject(subjectInTurkishLanguage);
            String subjectLowercase = subjectInTurkishLanguage.toLowerCase(turkishLocale);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().containsIgnoreCase(subjectLowercase)}))).contains((Object[])new DeletedMessage[]{message1});
        }
    }

    public static interface PerUserContract
    extends DeletedMessageVaultSearchContract {
        @Test
        default public void searchForAnUserShouldNotReturnMessagesFromAnotherUser() {
            DeletedMessage message1 = this.storeDeletedMessage(DeletedMessageFixture.DELETED_MESSAGE);
            DeletedMessage message2 = this.storeDeletedMessage(DeletedMessageFixture.DELETED_MESSAGE_2);
            this.storeDeletedMessage(DeletedMessageFixture.DELETED_MESSAGE_OTHER_USER);
            Assertions.assertThat(this.search(DeletedMessageFixture.USERNAME, Query.ALL)).containsOnly((Object[])new DeletedMessage[]{message1, message2});
        }
    }

    public static interface MultipleSearchCriterionsContract
    extends DeletedMessageVaultSearchContract {
        @Test
        default public void searchShouldReturnOnlyMessageWhichMatchMultipleCriterions() {
            DeletedMessage message1 = this.storeDefaultMessage();
            DeletedMessage message2 = this.storeDefaultMessage();
            DeletedMessage message3 = this.storeDefaultMessage();
            this.storeMessageWithOriginMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_2});
            this.storeMessageWithSender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER2));
            this.storeMessageWithDeletionDate(DeletedMessageFixture.DELETION_DATE.minusHours(1L));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.containsOriginMailbox((MailboxId)DeletedMessageFixture.MAILBOX_ID_1), CriterionFactory.hasSender((MailAddress)MailAddressFixture.SENDER), CriterionFactory.deletionDate().afterOrEquals(DeletedMessageFixture.DELETION_DATE)}))).containsOnly((Object[])new DeletedMessage[]{message1, message2, message3});
        }

        @Test
        default public void searchShouldReturnAllMessageWhenSearchForAllCriterions() {
            DeletedMessage message1 = this.storeDefaultMessage();
            DeletedMessage message2 = this.storeDefaultMessage();
            DeletedMessage message3 = this.storeDefaultMessage();
            DeletedMessage message4 = this.storeMessageWithOriginMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_2});
            DeletedMessage message5 = this.storeMessageWithSender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER2));
            DeletedMessage message6 = this.storeMessageWithDeletionDate(DeletedMessageFixture.DELETION_DATE.minusHours(1L));
            Assertions.assertThat(this.search(Query.ALL)).containsOnly((Object[])new DeletedMessage[]{message1, message2, message3, message4, message5, message6});
        }

        @Test
        default public void searchShouldReturnAllMessageEvenNullSubjectWhenSearchForAllCriterions() {
            DeletedMessage message1 = this.storeDefaultMessage();
            DeletedMessage message2 = this.storeDefaultMessage();
            DeletedMessage message3 = this.storeDefaultMessage();
            DeletedMessage message4 = this.storeMessageNoSubject();
            Assertions.assertThat(this.search(Query.ALL)).containsOnly((Object[])new DeletedMessage[]{message1, message2, message3, message4});
        }

        @Test
        default public void searchShouldReturnAllMessageEvenNullSenderWhenSearchForAllCriterions() {
            DeletedMessage message1 = this.storeDefaultMessage();
            DeletedMessage message2 = this.storeDefaultMessage();
            DeletedMessage message3 = this.storeDefaultMessage();
            DeletedMessage message4 = this.storeMessageWithSender(MaybeSender.nullSender());
            Assertions.assertThat(this.search(Query.ALL)).containsOnly((Object[])new DeletedMessage[]{message1, message2, message3, message4});
        }

        @Test
        default public void searchShouldReturnMessageWhenHavingSameCriterionTypes() {
            DeletedMessage message1 = this.storeMessageWithRecipients(MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2, MailAddressFixture.RECIPIENT3);
            DeletedMessage message2 = this.storeMessageWithRecipients(MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2);
            this.storeMessageWithRecipients(MailAddressFixture.RECIPIENT1);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.containsRecipient((MailAddress)MailAddressFixture.RECIPIENT1), CriterionFactory.containsRecipient((MailAddress)MailAddressFixture.RECIPIENT2)}))).containsOnly((Object[])new DeletedMessage[]{message1, message2});
        }

        @Test
        default public void searchShouldReturnEmptyWhenHavingSameCriterionTypesButOppositeMatching() {
            this.storeMessageWithDeletionDate(DeletedMessageFixture.DELETION_DATE);
            this.storeMessageWithDeletionDate(DeletedMessageFixture.DELETION_DATE);
            this.storeMessageWithDeletionDate(DeletedMessageFixture.DELETION_DATE.plusHours(2L));
            this.storeMessageWithDeletionDate(DeletedMessageFixture.DELETION_DATE.minusHours(2L));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.deletionDate().afterOrEquals(DeletedMessageFixture.DELETION_DATE.plusHours(1L)), CriterionFactory.deletionDate().beforeOrEquals(DeletedMessageFixture.DELETION_DATE.minusHours(1L))}))).isEmpty();
        }
    }

    public static interface SubjectContract
    extends DeletedMessageVaultSearchContract {
        public static final String APACHE_JAMES_PROJECT = "apache james project";
        public static final String OPEN_SOURCE_SOFTWARE = "open source software";

        @Test
        default public void shouldReturnMessagesContainsAtTheMiddle() {
            DeletedMessage message1 = this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().contains("james")}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldReturnMessagesContainsAtTheBeginning() {
            DeletedMessage message1 = this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().contains("apache")}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldReturnMessagesContainsAtTheEnd() {
            this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            DeletedMessage message2 = this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().contains("software")}))).containsOnly((Object[])new DeletedMessage[]{message2});
        }

        @Test
        default public void shouldNotReturnMissingSubjectMessagesWhenContains() {
            DeletedMessage message1 = this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageNoSubject();
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().contains("james")}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldNotReturnMessagesContainsIgnoreCaseWhenContains() {
            this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().contains("SoftWare")}))).isEmpty();
        }

        @Test
        default public void shouldReturnMessagesContainsIgnoreCaseAtTheMiddle() {
            DeletedMessage message1 = this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().containsIgnoreCase("JAmEs")}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldReturnMessagesContainsIgnoreCaseAtTheBeginning() {
            this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            DeletedMessage message2 = this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().containsIgnoreCase("SouRCE")}))).containsOnly((Object[])new DeletedMessage[]{message2});
        }

        @Test
        default public void shouldReturnMessagesContainsIgnoreCaseAtTheEnd() {
            DeletedMessage message1 = this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().containsIgnoreCase("ProJECT")}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldReturnMessagesContainsWhenContainsIgnoreCase() {
            DeletedMessage message1 = this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().containsIgnoreCase("project")}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldNotReturnMissingSubjectMessagesWhenContainsIgnoreCase() {
            DeletedMessage message1 = this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageNoSubject();
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().containsIgnoreCase("JAMes")}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldReturnMessagesStrictlyEquals() {
            DeletedMessage message1 = this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equals(APACHE_JAMES_PROJECT)}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldNotReturnMessagesContainsWhenEquals() {
            this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equals("james")}))).isEmpty();
        }

        @Test
        default public void shouldNotReturnMessagesContainsIgnoreCaseWhenEquals() {
            this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equals("proJECT")}))).isEmpty();
        }

        @Test
        default public void shouldNotReturnMessagesEqualsIgnoreCaseWhenEquals() {
            this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equals("Apache James Project")}))).isEmpty();
        }

        @Test
        default public void shouldReturnMessagesWhenEqualsIgnoreCase() {
            this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equals("Apache James PROJECT")}))).isEmpty();
        }

        @Test
        default public void shouldReturnMessagesStrictlyEqualsWhenEqualsIgnoreCase() {
            DeletedMessage message1 = this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equalsIgnoreCase(APACHE_JAMES_PROJECT)}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldNotReturnMessagesContainsWhenEqualsIgnoreCase() {
            this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equalsIgnoreCase("james")}))).isEmpty();
        }

        @Test
        default public void shouldNotReturnMessagesContainsIgnoreCaseWhenEqualsIgnoreCase() {
            this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageWithSubject(OPEN_SOURCE_SOFTWARE);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equalsIgnoreCase("proJECT")}))).isEmpty();
        }

        @Test
        default public void shouldNotReturnMissingSubjectMessagesWhenEquals() {
            DeletedMessage message1 = this.storeMessageWithSubject(APACHE_JAMES_PROJECT);
            this.storeMessageNoSubject();
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().equals(APACHE_JAMES_PROJECT)}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }
    }

    public static interface OriginMailboxesContract
    extends DeletedMessageVaultSearchContract {
        @Test
        default public void shouldReturnMessagesWithOriginMailboxesWhenContains() {
            DeletedMessage message1 = this.storeMessageWithOriginMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_1, DeletedMessageFixture.MAILBOX_ID_2});
            DeletedMessage message2 = this.storeMessageWithOriginMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_1});
            this.storeMessageWithOriginMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_3});
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.containsOriginMailbox((MailboxId)DeletedMessageFixture.MAILBOX_ID_1)}))).containsOnly((Object[])new DeletedMessage[]{message1, message2});
        }

        @Test
        default public void shouldReturnNoMessageWhenOriginMailboxesDoesntContains() {
            this.storeMessageWithOriginMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_1, DeletedMessageFixture.MAILBOX_ID_2});
            this.storeMessageWithOriginMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_1});
            this.storeMessageWithOriginMailboxes(new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_2});
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.containsOriginMailbox((MailboxId)DeletedMessageFixture.MAILBOX_ID_3)}))).isEmpty();
        }
    }

    public static interface HasAttachmentsContract
    extends DeletedMessageVaultSearchContract {
        @Test
        default public void shouldReturnMessagesWithAttachmentWhenHasAttachment() {
            DeletedMessage message1 = this.storeMessageWithHasAttachment(true);
            this.storeMessageWithHasAttachment(false);
            DeletedMessage message3 = this.storeMessageWithHasAttachment(true);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.hasAttachment()}))).containsOnly((Object[])new DeletedMessage[]{message1, message3});
        }

        @Test
        default public void shouldReturnMessagesWithOutAttachmentWhenHasNoAttachement() {
            DeletedMessage message1 = this.storeMessageWithHasAttachment(false);
            DeletedMessage message2 = this.storeMessageWithHasAttachment(false);
            this.storeMessageWithHasAttachment(true);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.hasNoAttachment()}))).containsOnly((Object[])new DeletedMessage[]{message1, message2});
        }
    }

    public static interface SenderContract
    extends DeletedMessageVaultSearchContract {
        @Test
        default public void shouldReturnMessagesWithSenderWhenEquals() {
            DeletedMessage message1 = this.storeMessageWithSender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER));
            this.storeMessageWithSender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER2));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.hasSender((MailAddress)MailAddressFixture.SENDER)}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldReturnNoMessageWhenSenderDoesntEquals() {
            this.storeMessageWithSender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER));
            this.storeMessageWithSender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER2));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.hasSender((MailAddress)MailAddressFixture.SENDER3)}))).isEmpty();
        }

        @Test
        default public void shouldNotReturnMessagesWithNullSenderWhenEquals() {
            DeletedMessage message1 = this.storeMessageWithSender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER));
            this.storeMessageWithSender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER2));
            this.storeMessageWithSender(MaybeSender.nullSender());
            this.storeMessageWithSender(MaybeSender.nullSender());
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.hasSender((MailAddress)MailAddressFixture.SENDER)}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }
    }

    public static interface RecipientsContract
    extends DeletedMessageVaultSearchContract {
        @Test
        default public void shouldReturnMessagesWithRecipientWhenContains() {
            DeletedMessage message1 = this.storeMessageWithRecipients(MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2);
            DeletedMessage message2 = this.storeMessageWithRecipients(MailAddressFixture.RECIPIENT1);
            this.storeMessageWithRecipients(MailAddressFixture.RECIPIENT3);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.containsRecipient((MailAddress)MailAddressFixture.RECIPIENT1)}))).containsOnly((Object[])new DeletedMessage[]{message1, message2});
        }

        @Test
        default public void shouldReturnNoMessageWhenDoesntContains() {
            this.storeMessageWithRecipients(MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2);
            this.storeMessageWithRecipients(MailAddressFixture.RECIPIENT1);
            this.storeMessageWithRecipients(MailAddressFixture.RECIPIENT2);
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.containsRecipient((MailAddress)MailAddressFixture.RECIPIENT3)}))).isEmpty();
        }
    }

    public static interface DeletionDateContract
    extends DeletedMessageVaultSearchContract {
        @Test
        default public void shouldReturnMessagesWithDeletionBeforeDateWhenBeforeOrEquals() {
            DeletedMessage message1 = this.storeMessageWithDeletionDate(DeletedMessageFixture.DELIVERY_DATE);
            this.storeMessageWithDeletionDate(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(60L));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.deletionDate().beforeOrEquals(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(30L))}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldReturnMessagesWithDeletionEqualDateWhenBeforeOrEquals() {
            DeletedMessage message1 = this.storeMessageWithDeletionDate(DeletedMessageFixture.DELIVERY_DATE);
            this.storeMessageWithDeletionDate(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(60L));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.deletionDate().beforeOrEquals(DeletedMessageFixture.DELIVERY_DATE)}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldReturnMessagesWithDeletionAfterDateWhenAfterOrEquals() {
            this.storeMessageWithDeletionDate(DeletedMessageFixture.DELIVERY_DATE);
            DeletedMessage message2 = this.storeMessageWithDeletionDate(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(60L));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.deletionDate().afterOrEquals(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(30L))}))).containsOnly((Object[])new DeletedMessage[]{message2});
        }

        @Test
        default public void shouldReturnMessagesWithDeletionEqualDateWhenAfterOrEquals() {
            this.storeMessageWithDeletionDate(DeletedMessageFixture.DELIVERY_DATE);
            DeletedMessage message2 = this.storeMessageWithDeletionDate(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(60L));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.deletionDate().afterOrEquals(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(60L))}))).containsOnly((Object[])new DeletedMessage[]{message2});
        }
    }

    public static interface DeliveryDateContract
    extends DeletedMessageVaultSearchContract {
        @Test
        default public void shouldReturnMessagesWithDeliveryBeforeDateWhenBeforeOrEquals() {
            DeletedMessage message1 = this.storeMessageWithDeliveryDate(DeletedMessageFixture.DELIVERY_DATE);
            this.storeMessageWithDeliveryDate(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(60L));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.deliveryDate().beforeOrEquals(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(30L))}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldReturnMessagesWithDeliveryEqualDateWhenBeforeOrEquals() {
            DeletedMessage message1 = this.storeMessageWithDeliveryDate(DeletedMessageFixture.DELIVERY_DATE);
            this.storeMessageWithDeliveryDate(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(60L));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.deliveryDate().beforeOrEquals(DeletedMessageFixture.DELIVERY_DATE)}))).containsOnly((Object[])new DeletedMessage[]{message1});
        }

        @Test
        default public void shouldReturnMessagesWithDeliveryAfterDateWhenAfterOrEquals() {
            this.storeMessageWithDeliveryDate(DeletedMessageFixture.DELIVERY_DATE);
            DeletedMessage message2 = this.storeMessageWithDeliveryDate(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(60L));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.deliveryDate().afterOrEquals(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(30L))}))).containsOnly((Object[])new DeletedMessage[]{message2});
        }

        @Test
        default public void shouldReturnMessagesWithDeliveryEqualDateWhenAfterOrEquals() {
            this.storeMessageWithDeliveryDate(DeletedMessageFixture.DELIVERY_DATE);
            DeletedMessage message2 = this.storeMessageWithDeliveryDate(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(60L));
            Assertions.assertThat(this.search(Query.of((Criterion[])new Criterion[]{CriterionFactory.deliveryDate().afterOrEquals(DeletedMessageFixture.DELIVERY_DATE.plusMinutes(60L))}))).containsOnly((Object[])new DeletedMessage[]{message2});
        }
    }

    public static interface AllContracts
    extends SubjectContract,
    DeletionDateContract,
    DeliveryDateContract,
    RecipientsContract,
    SenderContract,
    HasAttachmentsContract,
    OriginMailboxesContract,
    PerUserContract,
    MultipleSearchCriterionsContract,
    StringByLocaleContract {
    }
}

