/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.memory.MemoryBlobStore;
import org.apache.james.blob.memory.MemoryDumbBlobStore;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageConverter;
import org.apache.james.vault.DeletedMessageFixture;
import org.apache.james.vault.DeletedMessageVault;
import org.apache.james.vault.DeletedMessageVaultHook;
import org.apache.james.vault.RetentionConfiguration;
import org.apache.james.vault.blob.BlobStoreDeletedMessageVault;
import org.apache.james.vault.blob.BucketNameGenerator;
import org.apache.james.vault.memory.metadata.MemoryDeletedMessageMetadataVault;
import org.apache.james.vault.metadata.DeletedMessageMetadataVault;
import org.apache.james.vault.search.Query;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class DeletedMessageVaultHookTest {
    private static final String ALICE_ADDRESS = "alice@james.com";
    private static final String BOB_ADDRESS = "bob@james.com";
    private static final String TEST_ADDRESS = "test@james.com";
    private static final Username ALICE = Username.of((String)"alice@james.com");
    private static final Username BOB = Username.of((String)"bob@james.com");
    private static final String MESSAGE_BODY = "testmail";
    private static final MailboxPath MAILBOX_ALICE_ONE = MailboxPath.forUser((Username)ALICE, (String)"ALICE_ONE");
    private static final MailboxPath MAILBOX_BOB_ONE = MailboxPath.forUser((Username)BOB, (String)"BOB_ONE");
    private MailboxManager mailboxManager;
    private MessageIdManager messageIdManager;
    private Message mailContent;
    private DeletedMessageVault messageVault;
    private Clock clock;
    private MailboxSession aliceSession;
    private MailboxSession bobSession;
    private SearchQuery searchQuery;

    DeletedMessageVaultHookTest() {
    }

    private DeletedMessage buildDeletedMessage(List<MailboxId> mailboxIds, MessageId messageId, Username username, long messageSize) throws Exception {
        return ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId(messageId)).originMailboxes(mailboxIds)).user(username)).deliveryDate(DeletedMessageFixture.DELIVERY_DATE)).deletionDate(DeletedMessageFixture.DELETION_DATE)).sender(MaybeSender.getMailSender((String)ALICE_ADDRESS))).recipients(new MailAddress[]{new MailAddress(TEST_ADDRESS)})).hasAttachment(false)).size(messageSize)).subject("test").build();
    }

    private ComposedMessageId appendMessage(MessageManager messageManager) throws Exception {
        return messageManager.appendMessage(MessageManager.AppendCommand.builder().withInternalDate(DeletedMessageFixture.INTERNAL_DATE).build(this.mailContent), this.aliceSession);
    }

    @BeforeEach
    void setUp() throws Exception {
        this.clock = Clock.fixed(DeletedMessageFixture.DELETION_DATE.toInstant(), ZoneOffset.UTC);
        this.messageVault = new BlobStoreDeletedMessageVault((MetricFactory)new RecordingMetricFactory(), (DeletedMessageMetadataVault)new MemoryDeletedMessageMetadataVault(), (BlobStore)new MemoryBlobStore((BlobId.Factory)new HashBlobId.Factory(), new MemoryDumbBlobStore()), new BucketNameGenerator(this.clock), this.clock, RetentionConfiguration.DEFAULT);
        DeletedMessageConverter deletedMessageConverter = new DeletedMessageConverter();
        InMemoryIntegrationResources resources = InMemoryIntegrationResources.builder().preProvisionnedFakeAuthenticator().fakeAuthorizator().inVmEventBus().defaultAnnotationLimits().defaultMessageParser().scanningSearchIndex().preDeletionHookFactory(preInstanciationStage -> new DeletedMessageVaultHook((SessionProvider)preInstanciationStage.getSessionProvider(), this.messageVault, deletedMessageConverter, (MailboxSessionMapperFactory)preInstanciationStage.getMapperFactory(), this.clock)).storeQuotaManager().build();
        this.mailboxManager = resources.getMailboxManager();
        this.messageIdManager = resources.getMessageIdManager();
        this.mailContent = Message.Builder.of().setSubject("test").setBody(MESSAGE_BODY, StandardCharsets.UTF_8).setSender(ALICE_ADDRESS).setTo(TEST_ADDRESS).setDate(DeletedMessageFixture.INTERNAL_DATE).build();
        this.searchQuery = new SearchQuery();
        this.searchQuery.andCriteria(SearchQuery.internalDateOn((Date)DeletedMessageFixture.INTERNAL_DATE, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second));
        this.aliceSession = this.mailboxManager.createSystemSession(ALICE);
        this.bobSession = this.mailboxManager.createSystemSession(BOB);
    }

    @Test
    void notifyDeleteShouldAppendMessageVault() throws Exception {
        MailboxId aliceMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_ALICE_ONE, this.aliceSession).get();
        MessageManager messageManager = this.mailboxManager.getMailbox(aliceMailbox, this.aliceSession);
        ComposedMessageId composedId = this.appendMessage(messageManager);
        MessageId messageId = composedId.getMessageId();
        long messageSize = this.messageSize(messageManager, composedId);
        this.messageIdManager.delete((List)ImmutableList.of((Object)messageId), this.aliceSession);
        DeletedMessage deletedMessage = this.buildDeletedMessage((List<MailboxId>)ImmutableList.of((Object)aliceMailbox), messageId, ALICE, messageSize);
        Assertions.assertThat((Object)((DeletedMessage)Flux.from((Publisher)this.messageVault.search(ALICE, Query.ALL)).blockFirst())).isEqualTo((Object)deletedMessage);
    }

    @Test
    void notifyDeleteShouldAppendMessageToVaultOfMailboxOwnerWhenOtherUserDeleteMessageInSharingMailbox() throws Exception {
        MailboxId aliceMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_ALICE_ONE, this.aliceSession).get();
        MessageManager aliceMessageManager = this.mailboxManager.getMailbox(aliceMailbox, this.aliceSession);
        this.mailboxManager.setRights(MAILBOX_ALICE_ONE, MailboxACL.EMPTY.apply(MailboxACL.command().forUser(BOB).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read, MailboxACL.Right.DeleteMessages, MailboxACL.Right.PerformExpunge}).asAddition()), this.aliceSession);
        MessageManager bobMessageManager = this.mailboxManager.getMailbox(aliceMailbox, this.bobSession);
        ComposedMessageId composedMessageId = this.appendMessage(aliceMessageManager);
        MessageId messageId = composedMessageId.getMessageId();
        long messageSize = this.messageSize(bobMessageManager, composedMessageId);
        DeletedMessage deletedMessage = this.buildDeletedMessage((List<MailboxId>)ImmutableList.of((Object)aliceMailbox), messageId, ALICE, messageSize);
        bobMessageManager.delete((List)bobMessageManager.search(this.searchQuery, this.bobSession).collect(Guavate.toImmutableList()), this.bobSession);
        Assertions.assertThat((Object)((DeletedMessage)Flux.from((Publisher)this.messageVault.search(ALICE, Query.ALL)).blockFirst())).isEqualTo((Object)deletedMessage);
    }

    @Test
    void notifyDeleteShouldNotAppendMessageToVaultOfOtherUserOfMailboxWhenOtherUserDeleteMessageInSharingMailbox() throws Exception {
        MailboxId aliceMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_ALICE_ONE, this.aliceSession).get();
        MessageManager aliceMessageManager = this.mailboxManager.getMailbox(aliceMailbox, this.aliceSession);
        this.mailboxManager.setRights(MAILBOX_ALICE_ONE, MailboxACL.EMPTY.apply(MailboxACL.command().forUser(BOB).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read, MailboxACL.Right.DeleteMessages, MailboxACL.Right.PerformExpunge}).asAddition()), this.aliceSession);
        MessageManager bobMessageManager = this.mailboxManager.getMailbox(aliceMailbox, this.bobSession);
        this.appendMessage(aliceMessageManager);
        bobMessageManager.delete((List)bobMessageManager.search(this.searchQuery, this.bobSession).collect(Guavate.toImmutableList()), this.bobSession);
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.messageVault.search(BOB, Query.ALL)).collectList().block())).isEmpty();
    }

    @Test
    void notifyDeleteShouldAppendMessageToVaultOfOtherUserOfMailboxWhenOtherUserDeleteMessageAfterMoveToAnotherMailbox() throws Exception {
        MailboxId aliceMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_ALICE_ONE, this.aliceSession).get();
        MailboxId bobMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_BOB_ONE, this.bobSession).get();
        MessageManager aliceMessageManager = this.mailboxManager.getMailbox(aliceMailbox, this.aliceSession);
        MessageManager bobMessageManager = this.mailboxManager.getMailbox(bobMailbox, this.bobSession);
        ComposedMessageId composedMessageId = this.appendMessage(aliceMessageManager);
        MessageId messageId = composedMessageId.getMessageId();
        this.mailboxManager.setRights(MAILBOX_ALICE_ONE, MailboxACL.EMPTY.apply(MailboxACL.command().forUser(BOB).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read, MailboxACL.Right.DeleteMessages, MailboxACL.Right.PerformExpunge}).asAddition()), this.aliceSession);
        this.messageIdManager.setInMailboxes(messageId, (Collection)ImmutableList.of((Object)bobMailbox), this.bobSession);
        long messageSize = this.messageSize(bobMessageManager, composedMessageId);
        DeletedMessage deletedMessage = this.buildDeletedMessage((List<MailboxId>)ImmutableList.of((Object)bobMailbox), messageId, BOB, messageSize);
        bobMessageManager.delete((List)bobMessageManager.search(this.searchQuery, this.bobSession).collect(Guavate.toImmutableList()), this.bobSession);
        Assertions.assertThat((Object)((DeletedMessage)Flux.from((Publisher)this.messageVault.search(BOB, Query.ALL)).blockFirst())).isEqualTo((Object)deletedMessage);
    }

    @Test
    void notifyDeleteShouldNotAppendMessageToVaultOfMailboxOwnerWhenOtherUserDeleteMessageAfterMoveToAnotherMailbox() throws Exception {
        MailboxId aliceMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_ALICE_ONE, this.aliceSession).get();
        MailboxId bobMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_BOB_ONE, this.bobSession).get();
        MessageManager aliceMessageManager = this.mailboxManager.getMailbox(aliceMailbox, this.aliceSession);
        MessageManager bobMessageManager = this.mailboxManager.getMailbox(bobMailbox, this.bobSession);
        ComposedMessageId composedMessageId = this.appendMessage(aliceMessageManager);
        MessageId messageId = composedMessageId.getMessageId();
        this.mailboxManager.setRights(MAILBOX_ALICE_ONE, MailboxACL.EMPTY.apply(MailboxACL.command().forUser(BOB).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read, MailboxACL.Right.DeleteMessages, MailboxACL.Right.PerformExpunge}).asAddition()), this.aliceSession);
        this.messageIdManager.setInMailboxes(messageId, (Collection)ImmutableList.of((Object)bobMailbox), this.bobSession);
        bobMessageManager.delete((List)bobMessageManager.search(this.searchQuery, this.bobSession).collect(Guavate.toImmutableList()), this.bobSession);
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.messageVault.search(ALICE, Query.ALL)).collectList().block())).isEmpty();
    }

    @Test
    void notifyDeleteShouldAppendMessageToVaultOfOtherUserOfMailboxWhenOtherUserDeleteMessageAfterCopyToAnotherMailbox() throws Exception {
        MailboxId aliceMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_ALICE_ONE, this.aliceSession).get();
        MailboxId bobMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_BOB_ONE, this.bobSession).get();
        MessageManager aliceMessageManager = this.mailboxManager.getMailbox(aliceMailbox, this.aliceSession);
        MessageManager bobMessageManager = this.mailboxManager.getMailbox(bobMailbox, this.bobSession);
        ComposedMessageId composedMessageId = this.appendMessage(aliceMessageManager);
        MessageId messageId = composedMessageId.getMessageId();
        this.mailboxManager.setRights(MAILBOX_ALICE_ONE, MailboxACL.EMPTY.apply(MailboxACL.command().forUser(BOB).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read, MailboxACL.Right.DeleteMessages, MailboxACL.Right.PerformExpunge}).asAddition()), this.aliceSession);
        this.messageIdManager.setInMailboxes(messageId, (Collection)ImmutableList.of((Object)aliceMailbox, (Object)bobMailbox), this.bobSession);
        long messageSize = this.messageSize(bobMessageManager, composedMessageId);
        DeletedMessage deletedMessage = this.buildDeletedMessage((List<MailboxId>)ImmutableList.of((Object)bobMailbox), messageId, BOB, messageSize);
        bobMessageManager.delete((List)bobMessageManager.search(this.searchQuery, this.bobSession).collect(Guavate.toImmutableList()), this.bobSession);
        Assertions.assertThat((Object)((DeletedMessage)Flux.from((Publisher)this.messageVault.search(BOB, Query.ALL)).blockFirst())).isEqualTo((Object)deletedMessage);
    }

    @Test
    void notifyDeleteShouldNotAppendMessageToVaultOfMailboxOwnerWhenOtherUserDeleteMessageAfterCopyToAnotherMailbox() throws Exception {
        MailboxId aliceMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_ALICE_ONE, this.aliceSession).get();
        MailboxId bobMailbox = (MailboxId)this.mailboxManager.createMailbox(MAILBOX_BOB_ONE, this.bobSession).get();
        MessageManager aliceMessageManager = this.mailboxManager.getMailbox(aliceMailbox, this.aliceSession);
        MessageManager bobMessageManager = this.mailboxManager.getMailbox(bobMailbox, this.bobSession);
        ComposedMessageId composedMessageId = this.appendMessage(aliceMessageManager);
        MessageId messageId = composedMessageId.getMessageId();
        this.mailboxManager.setRights(MAILBOX_ALICE_ONE, MailboxACL.EMPTY.apply(MailboxACL.command().forUser(BOB).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read, MailboxACL.Right.DeleteMessages, MailboxACL.Right.PerformExpunge}).asAddition()), this.aliceSession);
        this.messageIdManager.setInMailboxes(messageId, (Collection)ImmutableList.of((Object)aliceMailbox, (Object)bobMailbox), this.bobSession);
        bobMessageManager.delete((List)bobMessageManager.search(this.searchQuery, this.bobSession).collect(Guavate.toImmutableList()), this.bobSession);
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.messageVault.search(ALICE, Query.ALL)).collectList().block())).isEmpty();
    }

    private long messageSize(MessageManager messageManager, ComposedMessageId composedMessageId) throws MailboxException {
        return ((MessageResult)messageManager.getMessages(MessageRange.one((MessageUid)composedMessageId.getUid()), FetchGroup.MINIMAL, this.aliceSession).next()).getSize();
    }
}

