/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.task.Task;
import org.apache.james.util.concurrency.ConcurrentTestRunner;
import org.apache.james.utils.UpdatableTickingClock;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageFixture;
import org.apache.james.vault.DeletedMessageVault;
import org.apache.james.vault.search.Criterion;
import org.apache.james.vault.search.CriterionFactory;
import org.apache.james.vault.search.Query;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DeletedMessageVaultContract {
    public static final Clock CLOCK = Clock.fixed(DeletedMessageFixture.NOW.toInstant(), DeletedMessageFixture.NOW.getZone());

    public DeletedMessageVault getVault();

    public UpdatableTickingClock getClock();

    @Test
    default public void searchAllShouldThrowOnNullUser() {
        Assertions.assertThatThrownBy(() -> this.getVault().search(null, Query.ALL)).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void searchAllShouldThrowOnNullQuery() {
        Assertions.assertThatThrownBy(() -> this.getVault().search(DeletedMessageFixture.USERNAME, null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void appendShouldThrowOnNullMessage() {
        Assertions.assertThatThrownBy(() -> this.getVault().append(null, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void appendShouldThrowOnNullContent() {
        Assertions.assertThatThrownBy(() -> this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void deleteShouldThrowOnNullMessageId() {
        Assertions.assertThatThrownBy(() -> this.getVault().delete(null, (MessageId)DeletedMessageFixture.MESSAGE_ID)).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void deleteShouldThrowOnNullUser() {
        Assertions.assertThatThrownBy(() -> this.getVault().delete(DeletedMessageFixture.USERNAME, null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void loadMimeMessageShouldThrowOnNullMessageId() {
        Assertions.assertThatThrownBy(() -> this.getVault().loadMimeMessage(null, (MessageId)DeletedMessageFixture.MESSAGE_ID)).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void loadMimeMessageShouldThrowOnNullUser() {
        Assertions.assertThatThrownBy(() -> this.getVault().loadMimeMessage(DeletedMessageFixture.USERNAME, null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void searchAllShouldReturnEmptyWhenNoItem() {
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.ALL)).collectList().block())).isEmpty();
    }

    @Test
    default public void searchAllShouldReturnContainedItems() {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.ALL)).collectList().block())).containsOnly((Object[])new DeletedMessage[]{DeletedMessageFixture.DELETED_MESSAGE});
    }

    @Test
    default public void searchAllShouldReturnAllContainedItems() {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE_2, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.ALL)).collectList().block())).containsOnly((Object[])new DeletedMessage[]{DeletedMessageFixture.DELETED_MESSAGE, DeletedMessageFixture.DELETED_MESSAGE_2});
    }

    @Test
    default public void searchShouldReturnMatchingItems() {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE_2, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE_WITH_SUBJECT, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.of((Criterion[])new Criterion[]{CriterionFactory.subject().containsIgnoreCase("subject")}))).collectList().block())).containsOnly((Object[])new DeletedMessage[]{DeletedMessageFixture.DELETED_MESSAGE_WITH_SUBJECT});
    }

    @Test
    default public void vaultShouldBePartitionnedByUser() {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME_2, Query.ALL)).collectList().block())).isEmpty();
    }

    @Test
    default public void searchAllShouldNotReturnDeletedItems() {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Mono.from((Publisher)this.getVault().delete(DeletedMessageFixture.USERNAME, (MessageId)DeletedMessageFixture.MESSAGE_ID)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.ALL)).collectList().block())).isEmpty();
    }

    @Test
    default public void loadMimeMessageShouldReturnEmptyWhenNone() {
        Assertions.assertThat((Optional)Mono.from((Publisher)this.getVault().loadMimeMessage(DeletedMessageFixture.USERNAME, (MessageId)DeletedMessageFixture.MESSAGE_ID)).blockOptional()).isEmpty();
    }

    @Test
    default public void loadMimeMessageShouldReturnStoredValue() {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        ((OptionalAssert)Assertions.assertThat((Optional)Mono.from((Publisher)this.getVault().loadMimeMessage(DeletedMessageFixture.USERNAME, (MessageId)DeletedMessageFixture.MESSAGE_ID)).blockOptional()).isNotEmpty()).satisfies(maybeContent -> Assertions.assertThat((InputStream)((InputStream)maybeContent.get())).hasSameContentAs((InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT)));
    }

    @Test
    default public void loadMimeMessageShouldReturnEmptyWhenDeleted() {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Mono.from((Publisher)this.getVault().delete(DeletedMessageFixture.USERNAME, (MessageId)DeletedMessageFixture.MESSAGE_ID)).block();
        Assertions.assertThat((Optional)Mono.from((Publisher)this.getVault().loadMimeMessage(DeletedMessageFixture.USERNAME, (MessageId)DeletedMessageFixture.MESSAGE_ID)).blockOptional()).isEmpty();
    }

    @Test
    default public void appendShouldRunSuccessfullyInAConcurrentContext() throws Exception {
        int operationCount = 10;
        int threadCount = 10;
        ConcurrentTestRunner.builder().operation((a, b) -> Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE_GENERATOR.apply(Long.valueOf(a * threadCount + b)), (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block()).threadCount(threadCount).operationCount(operationCount).runSuccessfullyWithin(Duration.ofMinutes(1L));
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.ALL)).collectList().block())).hasSize(threadCount * operationCount);
    }

    @Test
    default public void deleteShouldRunSuccessfullyInAConcurrentContext() throws Exception {
        int operationCount = 10;
        int threadCount = 10;
        Flux.range((int)0, (int)(operationCount * threadCount)).flatMap(i -> Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE_GENERATOR.apply((long)i), (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT)))).blockLast();
        ConcurrentTestRunner.builder().operation((a, b) -> Mono.from((Publisher)this.getVault().delete(DeletedMessageFixture.USERNAME, (MessageId)InMemoryMessageId.of((long)(a * threadCount + b)))).block()).threadCount(threadCount).operationCount(operationCount).runSuccessfullyWithin(Duration.ofMinutes(1L));
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.ALL)).collectList().block())).isEmpty();
    }

    @Test
    default public void deleteExpiredMessagesTaskShouldCompleteWhenNoMail() throws InterruptedException {
        Task.Result result = this.getVault().deleteExpiredMessagesTask().run();
        Assertions.assertThat((Comparable)result).isEqualTo((Object)Task.Result.COMPLETED);
    }

    @Test
    default public void deleteExpiredMessagesTaskShouldCompleteWhenAllMailsDeleted() throws InterruptedException {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Mono.from((Publisher)this.getVault().delete(DeletedMessageFixture.USERNAME, DeletedMessageFixture.DELETED_MESSAGE.getMessageId())).block();
        Task.Result result = this.getVault().deleteExpiredMessagesTask().run();
        Assertions.assertThat((Comparable)result).isEqualTo((Object)Task.Result.COMPLETED);
    }

    @Test
    default public void deleteExpiredMessagesTaskShouldCompleteWhenOnlyRecentMails() throws InterruptedException {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Task.Result result = this.getVault().deleteExpiredMessagesTask().run();
        Assertions.assertThat((Comparable)result).isEqualTo((Object)Task.Result.COMPLETED);
    }

    @Test
    default public void deleteExpiredMessagesTaskShouldCompleteWhenOnlyOldMails() throws InterruptedException {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.OLD_DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        Task.Result result = this.getVault().deleteExpiredMessagesTask().run();
        Assertions.assertThat((Comparable)result).isEqualTo((Object)Task.Result.COMPLETED);
    }

    @Test
    default public void deleteExpiredMessagesTaskShouldDoNothingWhenEmpty() throws InterruptedException {
        this.getVault().deleteExpiredMessagesTask().run();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.ALL)).collectList().block())).isEmpty();
    }

    @Test
    default public void deleteExpiredMessagesTaskShouldNotDeleteRecentMails() throws InterruptedException {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        this.getVault().deleteExpiredMessagesTask().run();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.ALL)).collectList().block())).containsOnly((Object[])new DeletedMessage[]{DeletedMessageFixture.DELETED_MESSAGE});
    }

    @Test
    default public void deleteExpiredMessagesTaskShouldDeleteOldMails() throws InterruptedException {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.OLD_DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        this.getClock().setInstant(DeletedMessageFixture.NOW.plusYears(2L).toInstant());
        this.getVault().deleteExpiredMessagesTask().run();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.ALL)).collectList().block())).isEmpty();
    }

    @Test
    default public void deleteExpiredMessagesTaskShouldDeleteOldMailsWhenRunSeveralTime() throws InterruptedException {
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.OLD_DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        this.getClock().setInstant(DeletedMessageFixture.NOW.plusYears(2L).toInstant());
        this.getVault().deleteExpiredMessagesTask().run();
        Mono.from((Publisher)this.getVault().append(DeletedMessageFixture.OLD_DELETED_MESSAGE, (InputStream)new ByteArrayInputStream(DeletedMessageFixture.CONTENT))).block();
        this.getClock().setInstant(DeletedMessageFixture.NOW.plusYears(4L).toInstant());
        this.getVault().deleteExpiredMessagesTask().run();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME, Query.ALL)).collectList().block())).isEmpty();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.getVault().search(DeletedMessageFixture.USERNAME_2, Query.ALL)).collectList().block())).isEmpty();
    }
}

