/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageFixture;
import org.apache.mailet.base.MailAddressFixture;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class DeletedMessageTest {
    DeletedMessageTest() {
    }

    @Test
    void deletedMessageShouldMatchBeanContract() {
        EqualsVerifier.forClass(DeletedMessage.class).verify();
    }

    @Test
    void buildShouldReturnDeletedMessageWithAllCompulsoryFields() {
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)DeletedMessageFixture.DELETED_MESSAGE.getMessageId()).isEqualTo((Object)DeletedMessageFixture.MESSAGE_ID);
            soft.assertThat(DeletedMessageFixture.DELETED_MESSAGE.getOriginMailboxes()).containsOnly((Object[])new MailboxId[]{DeletedMessageFixture.MAILBOX_ID_1, DeletedMessageFixture.MAILBOX_ID_2});
            soft.assertThat((Object)DeletedMessageFixture.DELETED_MESSAGE.getOwner()).isEqualTo((Object)DeletedMessageFixture.USERNAME);
            soft.assertThat(DeletedMessageFixture.DELETED_MESSAGE.getDeliveryDate()).isEqualTo(DeletedMessageFixture.DELIVERY_DATE);
            soft.assertThat(DeletedMessageFixture.DELETED_MESSAGE.getDeletionDate()).isEqualTo(DeletedMessageFixture.DELETION_DATE);
            soft.assertThat((Object)DeletedMessageFixture.DELETED_MESSAGE.getSender()).isEqualTo((Object)MaybeSender.of((MailAddress)MailAddressFixture.SENDER));
            soft.assertThat(DeletedMessageFixture.DELETED_MESSAGE.getRecipients()).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2});
            soft.assertThat(DeletedMessageFixture.DELETED_MESSAGE.hasAttachment()).isFalse();
            soft.assertThat(DeletedMessageFixture.DELETED_MESSAGE.getSize()).isEqualTo((long)DeletedMessageFixture.CONTENT.length);
            soft.assertThat(DeletedMessageFixture.DELETED_MESSAGE.getSubject()).isEmpty();
        });
    }

    @Test
    void buildShouldReturnDeletedMessageWithSubject() {
        Assertions.assertThat((Optional)DeletedMessageFixture.DELETED_MESSAGE_WITH_SUBJECT.getSubject()).contains((Object)"subject");
    }

    @Test
    void buildShouldThrowWhenPassingZeroSize() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeletedMessage.Builder.FinalStage)DeletedMessageFixture.SIZE_STAGE.size(0L)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("'size' is required to be a strictly positive number");
    }

    @Test
    void buildShouldThrowWhenPassingNegativeSize() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeletedMessage.Builder.FinalStage)DeletedMessageFixture.SIZE_STAGE.size(-1L)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("'size' is required to be a strictly positive number");
    }
}

