/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.vault.DeletedMessage;
import org.apache.mailet.base.MailAddressFixture;

public interface DeletedMessageFixture {
    public static final InMemoryMessageId MESSAGE_ID = InMemoryMessageId.of((long)42L);
    public static final InMemoryMessageId OLD_MESSAGE_ID = InMemoryMessageId.of((long)58L);
    public static final InMemoryMessageId MESSAGE_ID_2 = InMemoryMessageId.of((long)45L);
    public static final InMemoryId MAILBOX_ID_1 = InMemoryId.of((long)43L);
    public static final InMemoryId MAILBOX_ID_2 = InMemoryId.of((long)44L);
    public static final InMemoryId MAILBOX_ID_3 = InMemoryId.of((long)45L);
    public static final Username USERNAME = Username.of((String)"bob@apache.org");
    public static final Username USERNAME_2 = Username.of((String)"dimitri@apache.org");
    public static final ZonedDateTime DELIVERY_DATE = ZonedDateTime.parse("2014-10-30T14:12:00Z");
    public static final ZonedDateTime DELETION_DATE = ZonedDateTime.parse("2015-10-30T14:12:00Z");
    public static final ZonedDateTime NOW = ZonedDateTime.parse("2015-10-30T16:12:00Z");
    public static final ZonedDateTime OLD_DELIVERY_DATE = ZonedDateTime.parse("2010-10-30T14:12:00Z");
    public static final ZonedDateTime OLD_DELETION_DATE = ZonedDateTime.parse("2010-10-30T15:12:00Z");
    public static final Date INTERNAL_DATE = Date.from(DELIVERY_DATE.toInstant());
    public static final byte[] CONTENT = "header: value\r\n\r\ncontent".getBytes(StandardCharsets.UTF_8);
    public static final String SUBJECT = "subject";
    public static final Function<Long, DeletedMessage> DELETED_MESSAGE_GENERATOR = i -> ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId((MessageId)InMemoryMessageId.of((long)i))).originMailboxes(new MailboxId[]{MAILBOX_ID_1, MAILBOX_ID_2})).user(USERNAME)).deliveryDate(DELIVERY_DATE)).deletionDate(DELETION_DATE)).sender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER))).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2})).hasAttachment(false)).size((long)CONTENT.length)).build();
    public static final DeletedMessage.Builder.RequireSize<DeletedMessage.Builder.FinalStage> SIZE_STAGE = (DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId((MessageId)MESSAGE_ID)).originMailboxes(new MailboxId[]{MAILBOX_ID_1, MAILBOX_ID_2})).user(USERNAME)).deliveryDate(DELIVERY_DATE)).deletionDate(DELETION_DATE)).sender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER))).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2})).hasAttachment(false);
    public static final Supplier<DeletedMessage.Builder.FinalStage> FINAL_STAGE = () -> (DeletedMessage.Builder.FinalStage)SIZE_STAGE.size((long)CONTENT.length);
    public static final DeletedMessage DELETED_MESSAGE_WITH_SUBJECT = FINAL_STAGE.get().subject("subject").build();
    public static final DeletedMessage DELETED_MESSAGE = FINAL_STAGE.get().build();
    public static final DeletedMessage OLD_DELETED_MESSAGE = ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId((MessageId)OLD_MESSAGE_ID)).originMailboxes(new MailboxId[]{MAILBOX_ID_1, MAILBOX_ID_2})).user(USERNAME)).deliveryDate(OLD_DELIVERY_DATE)).deletionDate(OLD_DELETION_DATE)).sender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER))).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2})).hasAttachment(false)).size((long)CONTENT.length)).build();
    public static final DeletedMessage DELETED_MESSAGE_2 = DELETED_MESSAGE_GENERATOR.apply(MESSAGE_ID_2.getRawId());
    public static final DeletedMessage DELETED_MESSAGE_OTHER_USER = ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId((MessageId)InMemoryMessageId.of((long)48L))).originMailboxes(new MailboxId[]{MAILBOX_ID_1, MAILBOX_ID_2})).user(USERNAME_2)).deliveryDate(DELIVERY_DATE)).deletionDate(DELETION_DATE)).sender(MaybeSender.of((MailAddress)MailAddressFixture.SENDER))).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2})).hasAttachment(false)).size((long)CONTENT.length)).build();
}

