/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.Attachment;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.MessageBuilder;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageConverter;
import org.apache.james.vault.DeletedMessageFixture;
import org.apache.james.vault.DeletedMessageVaultHook;
import org.apache.mailet.base.MailAddressFixture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DeletedMessageConverterTest {
    private static final String FROM_FIELD = "From";
    private static final String TO_FIELD = "To";
    private static final String DATE_FIELD = "Date";
    private static final String SUBJECT_FIELD = "Subject";
    private static final String SENDER_FIELD = "Sender";
    private static final String CC_FIELD = "cc";
    private static final List<MailboxId> ORIGIN_MAILBOXES = ImmutableList.of((Object)DeletedMessageFixture.MAILBOX_ID_1, (Object)DeletedMessageFixture.MAILBOX_ID_2);
    private static final DeletedMessageVaultHook.DeletedMessageMailboxContext DELETED_MESSAGE_MAILBOX_CONTEXT = new DeletedMessageVaultHook.DeletedMessageMailboxContext((MessageId)DeletedMessageFixture.MESSAGE_ID, DeletedMessageFixture.USERNAME, ORIGIN_MAILBOXES);
    private static final Username EMPTY_OWNER = null;
    private static final Collection<MessageAttachment> NO_ATTACHMENT = ImmutableList.of();
    private static final Collection<MessageAttachment> ATTACHMENTS = ImmutableList.of((Object)MessageAttachment.builder().attachment(Attachment.builder().bytes("content".getBytes(StandardCharsets.UTF_8)).type("type").build()).build());
    private DeletedMessageConverter deletedMessageConverter;

    DeletedMessageConverterTest() {
    }

    private MessageBuilder getMessageBuilder() {
        return new MessageBuilder().header(SENDER_FIELD, MailAddressFixture.SENDER.asString()).header(FROM_FIELD, "alice@james.com").header(TO_FIELD, MailAddressFixture.RECIPIENT1.asString()).header(CC_FIELD, MailAddressFixture.RECIPIENT2.asString()).header(SUBJECT_FIELD, "subject").header(DATE_FIELD, "Thu, 30 Oct 2014 14:12:00 +0000 (GMT)");
    }

    private MailboxMessage buildMessage(MessageBuilder messageBuilder, Collection<MessageAttachment> attachments) throws Exception {
        MailboxMessage mailboxMessage = messageBuilder.size(DeletedMessageFixture.CONTENT.length).build((MessageId)DeletedMessageFixture.MESSAGE_ID);
        return SimpleMailboxMessage.fromWithoutAttachments((MailboxMessage)mailboxMessage).mailboxId(mailboxMessage.getMailboxId()).internalDate(Date.from(DeletedMessageFixture.DELIVERY_DATE.toInstant())).addAttachments(attachments).build();
    }

    @BeforeEach
    void setUp() {
        this.deletedMessageConverter = new DeletedMessageConverter();
    }

    @Test
    void convertShouldThrowWhenNoOwner() {
        DeletedMessageVaultHook.DeletedMessageMailboxContext deletedMessageMailboxContext = new DeletedMessageVaultHook.DeletedMessageMailboxContext((MessageId)DeletedMessageFixture.MESSAGE_ID, EMPTY_OWNER, ORIGIN_MAILBOXES);
        Assertions.assertThatThrownBy(() -> this.deletedMessageConverter.convert(deletedMessageMailboxContext, (Message)this.buildMessage(this.getMessageBuilder(), ATTACHMENTS), DeletedMessageFixture.DELETION_DATE)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void convertShouldReturnCorrespondingDeletedMessageWhenNoDeliveryDateInMimeMessageButInMailboxMessage() throws Exception {
        MessageBuilder builder = new MessageBuilder().header(SENDER_FIELD, MailAddressFixture.SENDER.asString()).header(FROM_FIELD, "alice@james.com").header(TO_FIELD, MailAddressFixture.RECIPIENT1.asString()).header(CC_FIELD, MailAddressFixture.RECIPIENT2.asString()).header(SUBJECT_FIELD, "subject");
        Assertions.assertThat((Object)this.deletedMessageConverter.convert(DELETED_MESSAGE_MAILBOX_CONTEXT, (Message)this.buildMessage(builder, NO_ATTACHMENT), DeletedMessageFixture.DELETION_DATE)).isEqualTo((Object)DeletedMessageFixture.DELETED_MESSAGE_WITH_SUBJECT);
    }

    @Test
    void convertShouldReturnCorrespondingDeletedMessageWhenNoSubject() throws Exception {
        MessageBuilder builder = new MessageBuilder().header(SENDER_FIELD, MailAddressFixture.SENDER.asString()).header(FROM_FIELD, "alice@james.com").header(TO_FIELD, MailAddressFixture.RECIPIENT1.asString()).header(CC_FIELD, MailAddressFixture.RECIPIENT2.asString()).header(DATE_FIELD, "Thu, 30 Oct 2014 14:12:00 +0000 (GMT)");
        Assertions.assertThat((Object)this.deletedMessageConverter.convert(DELETED_MESSAGE_MAILBOX_CONTEXT, (Message)this.buildMessage(builder, NO_ATTACHMENT), DeletedMessageFixture.DELETION_DATE)).isEqualTo((Object)DeletedMessageFixture.DELETED_MESSAGE);
    }

    @Test
    void convertShouldReturnCorrespondingDeletedMessage() throws Exception {
        MessageBuilder builder = this.getMessageBuilder();
        Assertions.assertThat((Object)this.deletedMessageConverter.convert(DELETED_MESSAGE_MAILBOX_CONTEXT, (Message)this.buildMessage(builder, NO_ATTACHMENT), DeletedMessageFixture.DELETION_DATE)).isEqualTo((Object)DeletedMessageFixture.DELETED_MESSAGE_WITH_SUBJECT);
    }

    @Test
    void convertShouldReturnCorrespondingDeletedMessageWhenNoRecipient() throws Exception {
        MessageBuilder builder = new MessageBuilder().header(SENDER_FIELD, MailAddressFixture.SENDER.asString()).header(FROM_FIELD, "alice@james.com").header(SUBJECT_FIELD, "subject").header(DATE_FIELD, "Thu, 30 Oct 2014 14:12:00 +0000 (GMT)");
        DeletedMessage deletedMessage = this.deletedMessageConverter.convert(DELETED_MESSAGE_MAILBOX_CONTEXT, (Message)this.buildMessage(builder, NO_ATTACHMENT), DeletedMessageFixture.DELETION_DATE);
        Assertions.assertThat((List)deletedMessage.getRecipients()).isEmpty();
    }

    @Test
    void convertShouldReturnCorrespondingDeletedMessageWhenInvalidRecipient() throws Exception {
        MessageBuilder builder = this.getMessageBuilder();
        builder.header(TO_FIELD, "bad@bad@bad");
        builder.header(CC_FIELD, "dad@");
        DeletedMessage deletedMessage = this.deletedMessageConverter.convert(DELETED_MESSAGE_MAILBOX_CONTEXT, (Message)this.buildMessage(builder, NO_ATTACHMENT), DeletedMessageFixture.DELETION_DATE);
        Assertions.assertThat((List)deletedMessage.getRecipients()).isEmpty();
    }

    @Test
    void convertShouldReturnCorrespondingDeletedMessageWhenInvalidHaveOneOfBadRecipient() throws Exception {
        MessageBuilder builder = this.getMessageBuilder();
        builder.header(TO_FIELD, "bad@bad@bad");
        DeletedMessage deletedMessage = this.deletedMessageConverter.convert(DELETED_MESSAGE_MAILBOX_CONTEXT, (Message)this.buildMessage(builder, NO_ATTACHMENT), DeletedMessageFixture.DELETION_DATE);
        Assertions.assertThat((List)deletedMessage.getRecipients()).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT2});
    }

    @Test
    void convertShouldReturnCorrespondingDeletedMessageWhenNoSender() throws Exception {
        MessageBuilder builder = new MessageBuilder().header(FROM_FIELD, "alice@james.com").header(TO_FIELD, MailAddressFixture.RECIPIENT1.asString()).header(CC_FIELD, MailAddressFixture.RECIPIENT2.asString()).header(SUBJECT_FIELD, "subject").header(DATE_FIELD, "Thu, 30 Oct 2014 14:12:00 +0000 (GMT)");
        DeletedMessage deletedMessage = this.deletedMessageConverter.convert(DELETED_MESSAGE_MAILBOX_CONTEXT, (Message)this.buildMessage(builder, NO_ATTACHMENT), DeletedMessageFixture.DELETION_DATE);
        Assertions.assertThat((Object)deletedMessage.getSender()).isEqualTo((Object)MaybeSender.nullSender());
    }
}

