/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.caching.guava;

import com.google.common.cache.Cache;
import java.util.Optional;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.caching.MailboxMetadataCache;
import org.apache.james.mailbox.caching.guava.AbstractGuavaCache;
import org.apache.james.mailbox.caching.guava.GuavaCacheWrapper;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class GuavaMailboxMetadataCache
extends AbstractGuavaCache
implements MailboxMetadataCache {
    private final Cache<MailboxId, Long> cacheCountMessagesInMailbox = BUILDER.build();
    private final Cache<MailboxId, Long> cacheCountUnseenMessagesInMailbox = BUILDER.build();
    private final Cache<MailboxId, MessageUid> cacheFindFirstUnseenMessageUid = BUILDER.build();
    private final Cache<MailboxId, Optional<MessageUid>> cacheGetLastUid = BUILDER.build();
    private final Cache<MailboxId, Long> cacheGetHighestModSeq = BUILDER.build();
    private final MetadataCacheWrapper<Long> countMessagesInMailboxWrapper = new CountMessagesInMailboxWrapper(this.cacheCountMessagesInMailbox);
    private final MetadataCacheWrapper<Long> countUnseenMessagesInMailboxWrapper = new CountUnseenMessagesInMailboxWrapper(this.cacheCountUnseenMessagesInMailbox);
    private final MetadataCacheWrapper<MessageUid> findFirstUnseenMessageUid = new FindFirstUnseenMessageUidWrapper(this.cacheFindFirstUnseenMessageUid);
    private final MetadataCacheWrapper<Long> highestModSeqWrapper = new HighestModseqCacheWrapper(this.cacheGetHighestModSeq);
    private final MetadataCacheWrapper<Optional<MessageUid>> lastUidWrapper = new LastUidCacheWrapper(this.cacheGetLastUid);

    @Override
    public long countMessagesInMailbox(Mailbox mailbox, MessageMapper underlying) throws MailboxException {
        return (Long)this.countMessagesInMailboxWrapper.get(mailbox, underlying);
    }

    @Override
    public long countUnseenMessagesInMailbox(Mailbox mailbox, MessageMapper underlying) throws MailboxException {
        return (Long)this.countUnseenMessagesInMailboxWrapper.get(mailbox, underlying);
    }

    @Override
    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox, MessageMapper underlying) throws MailboxException {
        return (MessageUid)this.findFirstUnseenMessageUid.get(mailbox, underlying);
    }

    @Override
    public Optional<MessageUid> getLastUid(Mailbox mailbox, MessageMapper underlying) throws MailboxException {
        return (Optional)this.lastUidWrapper.get(mailbox, underlying);
    }

    @Override
    public long getHighestModSeq(Mailbox mailbox, MessageMapper underlying) throws MailboxException {
        return (Long)this.highestModSeqWrapper.get(mailbox, underlying);
    }

    @Override
    public void invalidate(Mailbox mailbox) {
        this.cacheCountMessagesInMailbox.invalidate((Object)mailbox);
        this.cacheCountUnseenMessagesInMailbox.invalidate((Object)mailbox);
        this.cacheFindFirstUnseenMessageUid.invalidate((Object)mailbox);
        this.lastUidWrapper.invalidate(mailbox);
        this.highestModSeqWrapper.invalidate(mailbox);
    }

    class HighestModseqCacheWrapper
    extends MetadataCacheWrapper<Long> {
        public HighestModseqCacheWrapper(Cache<MailboxId, Long> cache) {
            super(cache);
        }

        @Override
        public Long load(Mailbox mailbox, MessageMapper underlying) throws MailboxException {
            return underlying.getHighestModSeq(mailbox);
        }
    }

    class LastUidCacheWrapper
    extends MetadataCacheWrapper<Optional<MessageUid>> {
        public LastUidCacheWrapper(Cache<MailboxId, Optional<MessageUid>> cache) {
            super(cache);
        }

        @Override
        public Optional<MessageUid> load(Mailbox mailbox, MessageMapper underlying) throws MailboxException {
            return underlying.getLastUid(mailbox);
        }
    }

    class FindFirstUnseenMessageUidWrapper
    extends MetadataCacheWrapper<MessageUid> {
        public FindFirstUnseenMessageUidWrapper(Cache<MailboxId, MessageUid> cache) {
            super(cache);
        }

        @Override
        public MessageUid load(Mailbox mailbox, MessageMapper underlying) throws MailboxException {
            return underlying.findFirstUnseenMessageUid(mailbox);
        }
    }

    class CountUnseenMessagesInMailboxWrapper
    extends MetadataCacheWrapper<Long> {
        public CountUnseenMessagesInMailboxWrapper(Cache<MailboxId, Long> cache) {
            super(cache);
        }

        @Override
        public Long load(Mailbox mailbox, MessageMapper underlying) throws MailboxException {
            return underlying.countUnseenMessagesInMailbox(mailbox);
        }
    }

    class CountMessagesInMailboxWrapper
    extends MetadataCacheWrapper<Long> {
        public CountMessagesInMailboxWrapper(Cache<MailboxId, Long> cache) {
            super(cache);
        }

        @Override
        public Long load(Mailbox mailbox, MessageMapper underlying) throws MailboxException {
            return underlying.countMessagesInMailbox(mailbox);
        }
    }

    abstract class MetadataCacheWrapper<ValueT>
    extends GuavaCacheWrapper<Mailbox, ValueT, MessageMapper, MailboxId, MailboxException> {
        public MetadataCacheWrapper(Cache<MailboxId, ValueT> cache) {
            super(cache);
        }

        @Override
        public MailboxId getKeyRepresentation(Mailbox key) {
            return key.getMailboxId();
        }
    }
}

