/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.caching.guava;

import com.google.common.cache.Cache;
import org.apache.james.mailbox.caching.MailboxByPathCache;
import org.apache.james.mailbox.caching.guava.AbstractGuavaCache;
import org.apache.james.mailbox.caching.guava.GuavaCacheWrapper;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class GuavaMailboxByPathCache
extends AbstractGuavaCache
implements MailboxByPathCache {
    private final Cache<String, Mailbox> findMailboxByPathCache = BUILDER.build();
    private final MailboxByPathCacheWrapper wrapper = new MailboxByPathCacheWrapper(this.findMailboxByPathCache);

    @Override
    public Mailbox findMailboxByPath(MailboxPath mailboxName, MailboxMapper underlying) throws MailboxNotFoundException, MailboxException {
        return (Mailbox)this.wrapper.get(mailboxName, underlying);
    }

    @Override
    public void invalidate(Mailbox mailbox) {
        this.invalidate(mailbox.generateAssociatedPath());
    }

    @Override
    public void invalidate(MailboxPath mailboxPath) {
        this.wrapper.invalidate(mailboxPath);
    }

    class MailboxByPathCacheWrapper
    extends GuavaCacheWrapper<MailboxPath, Mailbox, MailboxMapper, String, MailboxException> {
        public MailboxByPathCacheWrapper(Cache<String, Mailbox> cache) {
            super(cache);
        }

        @Override
        public Mailbox load(MailboxPath mailboxName, MailboxMapper underlying) throws MailboxException {
            return underlying.findMailboxByPath(mailboxName);
        }

        @Override
        public String getKeyRepresentation(MailboxPath key) {
            return key.toString();
        }
    }
}

