/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.caching.guava;

import com.google.common.cache.Cache;
import org.apache.james.mailbox.caching.CacheLoaderFromUnderlying;

public abstract class GuavaCacheWrapper<KeyT, ValueT, UnderlyingT, KeyRepresentationT, ExceptT extends Throwable>
implements CacheLoaderFromUnderlying<KeyT, ValueT, UnderlyingT, ExceptT> {
    private final Cache<KeyRepresentationT, ValueT> cache;

    public GuavaCacheWrapper(Cache<KeyRepresentationT, ValueT> cache) {
        this.cache = cache;
    }

    public ValueT get(KeyT key, UnderlyingT underlying) throws ExceptT {
        Object value = this.cache.getIfPresent(this.getKeyRepresentation(key));
        if (value != null) {
            return (ValueT)value;
        }
        value = this.load(key, underlying);
        if (value != null) {
            this.cache.put(this.getKeyRepresentation(key), value);
        }
        return (ValueT)value;
    }

    public void invalidate(KeyT key) {
        if (key != null) {
            this.cache.invalidate(this.getKeyRepresentation(key));
        }
    }

    public abstract KeyRepresentationT getKeyRepresentation(KeyT var1);
}

