/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.caching;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.caching.MailboxMetadataCache;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.transaction.Mapper;

public class CachingMessageMapper
implements MessageMapper {
    private final MessageMapper underlying;
    private final MailboxMetadataCache cache;

    public CachingMessageMapper(MessageMapper underlying, MailboxMetadataCache cache) {
        this.underlying = underlying;
        this.cache = cache;
    }

    public Iterator<MessageUid> listAllMessageUids(Mailbox mailbox) throws MailboxException {
        return this.underlying.listAllMessageUids(mailbox);
    }

    public void endRequest() {
        this.underlying.endRequest();
    }

    public <T> T execute(Mapper.Transaction<T> transaction) throws MailboxException {
        return (T)this.underlying.execute(transaction);
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange set, MessageMapper.FetchType type, int limit) throws MailboxException {
        return this.underlying.findInMailbox(mailbox, set, type, limit);
    }

    public Map<MessageUid, MessageMetaData> expungeMarkedForDeletionInMailbox(Mailbox mailbox, MessageRange set) throws MailboxException {
        this.invalidateMetadata(mailbox);
        return this.underlying.expungeMarkedForDeletionInMailbox(mailbox, set);
    }

    public long countMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        return this.cache.countMessagesInMailbox(mailbox, this.underlying);
    }

    public long countUnseenMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        return this.cache.countUnseenMessagesInMailbox(mailbox, this.underlying);
    }

    public MailboxCounters getMailboxCounters(Mailbox mailbox) throws MailboxException {
        return MailboxCounters.builder().count(this.countMessagesInMailbox(mailbox)).unseen(this.countUnseenMessagesInMailbox(mailbox)).build();
    }

    public void delete(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        this.invalidateMetadata(mailbox);
        this.underlying.delete(mailbox, message);
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) throws MailboxException {
        return this.cache.findFirstUnseenMessageUid(mailbox, this.underlying);
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) throws MailboxException {
        return this.underlying.findRecentMessageUidsInMailbox(mailbox);
    }

    public MessageMetaData add(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        this.invalidateMetadata(mailbox);
        return this.underlying.add(mailbox, message);
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox mailbox, FlagsUpdateCalculator calculator, MessageRange set) throws MailboxException {
        if (set.iterator().hasNext()) {
            this.invalidateMetadata(mailbox);
        }
        return this.underlying.updateFlags(mailbox, calculator, set);
    }

    public MessageMetaData copy(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        this.invalidateMetadata(mailbox);
        return this.underlying.copy(mailbox, original);
    }

    public Optional<MessageUid> getLastUid(Mailbox mailbox) throws MailboxException {
        return this.cache.getLastUid(mailbox, this.underlying);
    }

    public long getHighestModSeq(Mailbox mailbox) throws MailboxException {
        return this.cache.getHighestModSeq(mailbox, this.underlying);
    }

    private void invalidateMetadata(Mailbox mailbox) {
        this.cache.invalidate(mailbox);
    }

    public MessageMetaData move(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        throw new UnsupportedOperationException("Move is not yet supported");
    }

    public Flags getApplicableFlag(Mailbox mailbox) throws MailboxException {
        return this.underlying.getApplicableFlag(mailbox);
    }
}

