/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.caching;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.caching.CachingMailboxMapper;
import org.apache.james.mailbox.caching.CachingMessageMapper;
import org.apache.james.mailbox.caching.MailboxByPathCache;
import org.apache.james.mailbox.caching.MailboxMetadataCache;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class CachingMailboxSessionMapperFactory
extends MailboxSessionMapperFactory {
    private final MailboxSessionMapperFactory underlying;
    private final MailboxByPathCache mailboxByPathCache;
    private final MailboxMetadataCache mailboxMetadataCache;

    public CachingMailboxSessionMapperFactory(MailboxSessionMapperFactory underlying, MailboxByPathCache mailboxByPathCache, MailboxMetadataCache mailboxMetadataCache) {
        this.underlying = underlying;
        this.mailboxByPathCache = mailboxByPathCache;
        this.mailboxMetadataCache = mailboxMetadataCache;
    }

    public MessageMapper createMessageMapper(MailboxSession session) throws MailboxException {
        return new CachingMessageMapper(this.underlying.createMessageMapper(session), this.mailboxMetadataCache);
    }

    public MailboxMapper createMailboxMapper(MailboxSession session) throws MailboxException {
        return new CachingMailboxMapper(this.underlying.createMailboxMapper(session), this.mailboxByPathCache);
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) throws SubscriptionException {
        return this.underlying.createSubscriptionMapper(session);
    }

    public AnnotationMapper createAnnotationMapper(MailboxSession session) throws MailboxException {
        throw new NotImplementedException("Not implemented");
    }

    public UidProvider getUidProvider() {
        return this.underlying.getUidProvider();
    }

    public ModSeqProvider getModSeqProvider() {
        return this.underlying.getModSeqProvider();
    }

    public MessageIdMapper createMessageIdMapper(MailboxSession session) throws MailboxException {
        throw new NotImplementedException("Not implemented");
    }
}

