/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.caching;

import java.util.List;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.caching.MailboxByPathCache;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.transaction.Mapper;

public class CachingMailboxMapper
implements MailboxMapper {
    private final MailboxMapper underlying;
    private final MailboxByPathCache cache;

    public CachingMailboxMapper(MailboxMapper underlying, MailboxByPathCache cache) {
        this.underlying = underlying;
        this.cache = cache;
    }

    public void endRequest() {
        this.underlying.endRequest();
    }

    public <T> T execute(Mapper.Transaction<T> transaction) throws MailboxException {
        return (T)this.underlying.execute(transaction);
    }

    public MailboxId save(Mailbox mailbox) throws MailboxException {
        this.invalidate(mailbox);
        return this.underlying.save(mailbox);
    }

    public void delete(Mailbox mailbox) throws MailboxException {
        this.invalidate(mailbox);
        this.underlying.delete(mailbox);
    }

    public Mailbox findMailboxByPath(MailboxPath mailboxName) throws MailboxException, MailboxNotFoundException {
        try {
            return this.cache.findMailboxByPath(mailboxName, this.underlying);
        }
        catch (MailboxNotFoundException e) {
            this.cache.invalidate(mailboxName);
            throw e;
        }
    }

    public Mailbox findMailboxById(MailboxId mailboxId) throws MailboxException {
        return this.underlying.findMailboxById(mailboxId);
    }

    public List<Mailbox> findMailboxWithPathLike(MailboxPath mailboxPath) throws MailboxException {
        return this.underlying.findMailboxWithPathLike(mailboxPath);
    }

    public boolean hasChildren(Mailbox mailbox, char delimiter) throws MailboxException, MailboxNotFoundException {
        return this.underlying.hasChildren(mailbox, delimiter);
    }

    public List<Mailbox> list() throws MailboxException {
        return this.underlying.list();
    }

    public ACLDiff updateACL(Mailbox mailbox, MailboxACL.ACLCommand mailboxACLCommand) throws MailboxException {
        MailboxACL oldACL = mailbox.getACL();
        MailboxACL newACL = mailbox.getACL().apply(mailboxACLCommand);
        mailbox.setACL(newACL);
        return ACLDiff.computeDiff((MailboxACL)oldACL, (MailboxACL)newACL);
    }

    public ACLDiff setACL(Mailbox mailbox, MailboxACL mailboxACL) throws MailboxException {
        MailboxACL oldMailboxAcl = mailbox.getACL();
        mailbox.setACL(mailboxACL);
        return ACLDiff.computeDiff((MailboxACL)oldMailboxAcl, (MailboxACL)mailboxACL);
    }

    private void invalidate(Mailbox mailbox) {
        this.cache.invalidate(mailbox);
    }

    public List<Mailbox> findNonPersonalMailboxes(String userName, MailboxACL.Right right) throws MailboxException {
        return this.underlying.findNonPersonalMailboxes(userName, right);
    }
}

