/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.caching;

import org.apache.james.mailbox.caching.MailboxByPathCache;
import org.apache.james.mailbox.caching.MailboxMetadataCache;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.Group;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.exception.MailboxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheInvalidatingMailboxListener
implements MailboxListener.GroupMailboxListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheInvalidatingMailboxListener.class);
    private static final Group GROUP = new CacheInvalidatingMailboxListenerGroup();
    private final MailboxByPathCache mailboxCacheByPath;
    private final MailboxMetadataCache mailboxMetadataCache;

    public CacheInvalidatingMailboxListener(MailboxByPathCache mailboxCacheByPath, MailboxMetadataCache mailboxMetadataCache) {
        this.mailboxCacheByPath = mailboxCacheByPath;
        this.mailboxMetadataCache = mailboxMetadataCache;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public void register(EventBus eventBus) {
        eventBus.register((MailboxListener.GroupMailboxListener)this);
    }

    public void event(Event event) {
        if (event instanceof MailboxListener.MailboxEvent) {
            this.mailboxEvent((MailboxListener.MailboxEvent)event);
        }
    }

    private void mailboxEvent(MailboxListener.MailboxEvent event) {
        try {
            if (event instanceof MailboxListener.MessageEvent) {
                this.invalidateMetadata(event);
            }
            this.invalidateMailbox(event);
        }
        catch (MailboxException e) {
            LOGGER.error("Error while invalidation cache", (Throwable)e);
        }
    }

    private void invalidateMetadata(MailboxListener.MailboxEvent event) throws MailboxException {
        this.mailboxMetadataCache.invalidate(this.mailboxCacheByPath.findMailboxByPath(event.getMailboxPath(), null));
    }

    private void invalidateMailbox(MailboxListener.MailboxEvent event) {
        this.mailboxCacheByPath.invalidate(event.getMailboxPath());
    }

    private static class CacheInvalidatingMailboxListenerGroup
    extends Group {
        private CacheInvalidatingMailboxListenerGroup() {
        }
    }
}

